/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class NobodyCreeperEntity
extends BaseKHEntity {
    public NobodyCreeperEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 6;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(0, (Goal)new NobodyCreeperGoal(this));
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.17).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.KNOCKBACK_RESISTANCE, 1000.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.NOBODY;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    class NobodyCreeperGoal
    extends Goal {
        private final NobodyCreeperEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 5;
        private int whileAttackTimer;
        private double[] posToFall;

        public NobodyCreeperGoal(NobodyCreeperEntity e) {
            this.theEntity = e;
        }

        public boolean canUse() {
            if (this.theEntity.getTarget() != null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            boolean flag = this.canUseAttack;
            return flag;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = this.theEntity.getState() > 2 ? 10 + NobodyCreeperEntity.this.level().random.nextInt(5) : 20 + NobodyCreeperEntity.this.level().random.nextInt(5);
            this.theEntity.setState(0);
            this.theEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.17);
            this.whileAttackTimer = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void tick() {
            if (this.theEntity.getTarget() == null || !this.canUseAttack) return;
            this.whileAttackTimer += 2;
            LivingEntity target = this.theEntity.getTarget();
            if (this.theEntity.getState() == 0) {
                this.theEntity.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                if ((double)NobodyCreeperEntity.this.level().random.nextInt(100) + NobodyCreeperEntity.this.level().random.nextDouble() <= 75.0) {
                    if ((double)NobodyCreeperEntity.this.level().random.nextInt(100) + NobodyCreeperEntity.this.level().random.nextDouble() <= 50.0) {
                        if (!(this.theEntity.distanceTo((Entity)this.theEntity.getTarget()) < 8.0f)) return;
                        this.theEntity.setState(1);
                        this.theEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                        for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.theEntity, 4.0)) {
                            this.theEntity.doHurtTarget((Entity)enemy);
                        }
                    } else {
                        if (!(this.theEntity.distanceTo((Entity)this.theEntity.getTarget()) < 16.0f)) return;
                        this.theEntity.setState(2);
                        this.theEntity.teleportTo(target.getX(), target.getY() + 4.0, target.getZ());
                        this.theEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                        for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.theEntity, 3.0)) {
                            this.theEntity.doHurtTarget((Entity)enemy);
                        }
                    }
                } else {
                    if (!(this.theEntity.distanceTo((Entity)this.theEntity.getTarget()) < 5.0f)) return;
                    this.theEntity.setState(3);
                    this.theEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                    for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.theEntity, 2.5)) {
                        enemy.hurt(enemy.damageSources().mobAttack((LivingEntity)this.theEntity), 4.0f);
                    }
                }
            }
            if (this.theEntity.getState() == 1 && this.whileAttackTimer > 20) {
                this.canUseAttack = false;
                this.theEntity.setState(0);
                this.theEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.17);
                return;
            } else {
                if (this.theEntity.getState() == 1 || this.whileAttackTimer <= 30) return;
                this.canUseAttack = false;
                this.theEntity.setState(0);
                this.theEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.17);
            }
        }
    }
}

