/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.magic.FireEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseElementalMusicalHeartlessEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;

public class RedNocturneEntity
extends BaseElementalMusicalHeartlessEntity {
    public RedNocturneEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 6;
    }

    @Override
    protected Goal goalToUse() {
        return new RedNocturneGoal(this);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return BaseElementalMusicalHeartlessEntity.registerAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    public BaseElementalMusicalHeartlessEntity.Element getElementToUse() {
        return BaseElementalMusicalHeartlessEntity.Element.FIRE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/red_nocturne.png");
    }

    public boolean hurt(DamageSource source, float amount) {
        float multiplier = 1.0f;
        if (!this.level().isClientSide) {
            if (source.getMsgId().equals(KKResistanceType.ice.toString())) {
                multiplier = 2.0f;
            }
            if (source.getMsgId().equals(KKResistanceType.fire.toString())) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY() + 1.0, this.getZ(), 10, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, 0.0);
                return false;
            }
        }
        return super.hurt(source, amount * multiplier);
    }

    class RedNocturneGoal
    extends TargetGoal {
        private boolean canUseAttack;
        private int attackTimer;
        private int whileAttackTimer;
        private int shotChargeTimer;
        private final BaseKHEntity mob;

        public RedNocturneGoal(RedNocturneEntity e) {
            super((Mob)e, true);
            this.canUseAttack = true;
            this.attackTimer = 5;
            this.shotChargeTimer = 40;
            this.mob = e;
        }

        public boolean canUse() {
            if (this.mob.getTarget() != null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUseAttack;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 20 + RedNocturneEntity.this.level().random.nextInt(5);
            this.mob.setState(0);
            this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
            this.whileAttackTimer = 0;
        }

        public void tick() {
            if (this.mob.getTarget() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                LivingEntity target = this.mob.getTarget();
                if (this.mob.getState() == 0) {
                    this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                    if ((double)RedNocturneEntity.this.level().random.nextInt(100) + RedNocturneEntity.this.level().random.nextDouble() <= 75.0) {
                        this.mob.setState(1);
                    } else if (this.mob.distanceTo((Entity)this.mob.getTarget()) < 8.0f) {
                        this.mob.setState(2);
                        this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                        for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.mob, 4.0)) {
                            enemy.hurt(enemy.damageSources().mobAttack((LivingEntity)this.mob), 4.0f);
                        }
                    } else {
                        return;
                    }
                }
                if (this.mob.getState() == 2 && this.whileAttackTimer > 20) {
                    this.canUseAttack = false;
                    this.mob.setState(0);
                    this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
                } else if (this.mob.getState() == 1) {
                    if (this.shotChargeTimer > 0) {
                        --this.shotChargeTimer;
                        this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                        ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.FLAME, this.mob.getX(), this.mob.getY() + 2.5, this.mob.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                    } else {
                        this.mob.getLookControl().setLookAt((Entity)target, 0.0f, 0.0f);
                        this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
                        double d1 = this.mob.getTarget().getX() - this.mob.getX();
                        double d2 = this.mob.getTarget().getBoundingBox().minY + (double)(this.mob.getTarget().getBbHeight() / 2.0f) - (this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f));
                        double d3 = this.mob.getTarget().getZ() - this.mob.getZ();
                        FireEntity esfb = new FireEntity(this.mob.level(), (LivingEntity)this.mob, (float)this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue(), null);
                        esfb.shoot(d1, d2, d3, 1.0f, 0.0f);
                        esfb.setPos(esfb.getX(), this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f) + 0.5, esfb.getZ());
                        this.mob.level().addFreshEntity((Entity)esfb);
                        if (this.whileAttackTimer > 50) {
                            this.canUseAttack = false;
                            this.mob.setState(0);
                            this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
                            this.shotChargeTimer = 40;
                        }
                    }
                }
            }
        }
    }
}

