/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class SeedBulletEntity
extends ThrowableProjectile {
    private final int ticks = 80;

    public SeedBulletEntity(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public SeedBulletEntity(double x, double y, double z, Level worldIn) {
        super(ModEntities.TYPE_SEED_BULLET.get(), x, y, z, worldIn);
    }

    public SeedBulletEntity(LivingEntity livingEntityIn, Level worldIn) {
        super(ModEntities.TYPE_SEED_BULLET.get(), livingEntityIn, worldIn);
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide && this.getOwner() != null && this.getOwner() instanceof LivingEntity && result instanceof EntityHitResult) {
            Entity target = ((EntityHitResult)result).getEntity();
            ((LivingEntity)this.getOwner()).doHurtTarget(target);
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        if (this.tickCount >= 80) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        super.tick();
    }
}

