/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SpawningOrbEntity
extends Monster {
    Monster mob;
    boolean portal;
    private static final EntityDataAccessor<String> ENTITY_TYPE = SynchedEntityData.defineId(SpawningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public SpawningOrbEntity(EntityType<? extends SpawningOrbEntity> type, Level worldIn) {
        super(type, worldIn);
        Player player = Utils.getClosestPlayer((Entity)this, worldIn);
        if (player != null) {
            PlayerData playerData = PlayerData.get(player);
            if (playerData == null) {
                return;
            }
            this.mob = ModEntities.getRandomEnemy(playerData.getLevel(), this.level());
            this.setEntityType(((IKHMob)this.mob).getKHMobType().name());
            int randomLevel = Utils.getRandomMobLevel(player);
            GlobalData mobData = GlobalData.get((LivingEntity)this.mob);
            if (mobData != null) {
                mobData.setLevel(randomLevel);
                PacketHandler.syncToAllAround((LivingEntity)this.mob, mobData);
            }
        }
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        if (worldIn instanceof Level) {
            Level level = (Level)worldIn;
            return WorldData.get(level.getServer()).getHeartlessSpawnLevel() > 0;
        }
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void tick() {
        SimpleParticleType particle;
        if (this.tickCount == 1 && !this.level().isClientSide && this.mob != null) {
            if (this.level().random.nextDouble() < 0.1) {
                this.setPortal(true);
            }
            this.setEntityType(((IKHMob)this.mob).getKHMobType().name());
        }
        SimpleParticleType simpleParticleType = particle = this.getEntityType().equals(EntityHelper.MobType.NOBODY.name()) ? ParticleTypes.END_ROD : ParticleTypes.DRAGON_BREATH;
        if (this.tickCount > 10 && this.tickCount < 60) {
            double x = this.getX() + (this.level().random.nextDouble() - 0.5) * 2.0;
            double y = this.getY() + (this.level().random.nextDouble() - 0.5) * 2.0 + 1.0;
            double z = this.getZ() + (this.level().random.nextDouble() - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
        }
        if (this.tickCount == 70) {
            if (!this.level().isClientSide) {
                if (this.mob != null) {
                    this.mob.setPos(this.getX(), this.getY(), this.getZ());
                    this.mob.heal(this.mob.getMaxHealth());
                    this.level().addFreshEntity((Entity)this.mob);
                }
            } else {
                float radius = 0.5f;
                double X = this.getX();
                double Y = this.getY();
                double Z = this.getZ();
                for (int t = 1; t < 360; t += 20) {
                    for (int s = 1; s < 360; s += 20) {
                        double x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double y = Y + (double)radius * Math.cos(Math.toRadians(t)) + 1.0;
                        this.level().addParticle((ParticleOptions)particle, x, y, z, (this.level().random.nextDouble() - 0.5) / 4.0, (this.level().random.nextDouble() - 0.5) / 4.0, (this.level().random.nextDouble() - 0.5) / 4.0);
                    }
                }
            }
        }
        if (this.tickCount >= 100) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        super.tick();
    }

    public void setPortal(boolean portal) {
        this.portal = portal;
    }

    public boolean getPortal() {
        return this.portal;
    }

    public void playerTouch(Player nPlayer) {
        if (this.getPortal()) {
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"realm_of_darkness"));
            PlayerData playerData = PlayerData.get(nPlayer);
            if (playerData == null) {
                return;
            }
            playerData.setRespawnROD(true);
            if (!nPlayer.level().isClientSide()) {
                PacketHandler.sendTo(new SCSyncPlayerData(nPlayer), (ServerPlayer)nPlayer);
            }
            BlockPos coords = nPlayer.getServer().getLevel(dimension).getSharedSpawnPos();
            nPlayer.changeDimension(new DimensionTransition(nPlayer.getServer().getLevel(dimension), new Vec3((double)coords.getX(), (double)coords.getY(), (double)coords.getZ()), Vec3.ZERO, nPlayer.getYRot(), nPlayer.getXRot(), entity -> {}));
            nPlayer.sendSystemMessage((Component)Component.translatable((String)("You have been teleported to " + String.valueOf(dimension.location()))));
        }
        super.playerTouch(nPlayer);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.KNOCKBACK_RESISTANCE, 1000.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.entityData.get(ENTITY_TYPE) != null) {
            compound.putString("entity", (String)this.entityData.get(ENTITY_TYPE));
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(ENTITY_TYPE, (Object)compound.getString("entity"));
    }

    public String getEntityType() {
        return (String)this.getEntityData().get(ENTITY_TYPE);
    }

    public void setEntityType(String type) {
        this.entityData.set(ENTITY_TYPE, (Object)type);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ENTITY_TYPE, (Object)"");
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }
}

