/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.goal.WhiteMushroomGoal;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class WhiteMushroomEntity
extends BaseKHEntity {
    int satisfied = 0;

    public WhiteMushroomEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 2;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide()) {
            if (source.is(KKDamageTypes.FIRE)) {
                this.extinguishFire();
                this.checkSatisfy(1);
            } else if (source.is(KKDamageTypes.ICE)) {
                this.checkSatisfy(2);
            } else if (source.is(KKDamageTypes.LIGHTNING)) {
                this.checkSatisfy(3);
            } else {
                this.setState(-2);
            }
        }
        return false;
    }

    private void checkSatisfy(int i) {
        if (this.getState() >= 0) {
            if (this.getState() == i) {
                this.setState(-1);
                ++this.satisfied;
                if (this.satisfied >= 3) {
                    this.setState(-3);
                    ItemEntity ie = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), Utils.getWhiteMushroomReward());
                    this.level().addFreshEntity((Entity)ie);
                }
            } else {
                this.setState(-2);
            }
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(4, (Goal)new WhiteMushroomGoal(this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 15.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.HEARTLESS_EMBLEM;
    }
}

