/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseElementalMusicalHeartlessEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import org.joml.Vector3f;

public class YellowOperaEntity
extends BaseElementalMusicalHeartlessEntity {
    public YellowOperaEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 6;
    }

    @Override
    protected Goal goalToUse() {
        return new YellowOperaGoal(this);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return BaseElementalMusicalHeartlessEntity.registerAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    public BaseElementalMusicalHeartlessEntity.Element getElementToUse() {
        return BaseElementalMusicalHeartlessEntity.Element.THUNDER;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/yellow_opera.png");
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide && source.getMsgId().equals(KKResistanceType.lightning.toString())) {
            this.extinguishFire();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f), this.getX(), this.getY() + 1.0, this.getZ(), 10, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, 0.0);
            return false;
        }
        return super.hurt(source, amount);
    }

    class YellowOperaGoal
    extends TargetGoal {
        private boolean canUseAttack;
        private int attackTimer;
        private int whileAttackTimer;
        private int shotChargeTimer;
        private float initialHealth;
        private final BaseKHEntity mob;

        public YellowOperaGoal(YellowOperaEntity e) {
            super((Mob)e, true);
            this.canUseAttack = true;
            this.attackTimer = 5;
            this.shotChargeTimer = 50;
            this.mob = e;
        }

        public boolean canUse() {
            if (this.mob.getTarget() != null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUseAttack;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 25 + YellowOperaEntity.this.level().random.nextInt(5);
            this.mob.setState(0);
            this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
            this.whileAttackTimer = 0;
            this.initialHealth = this.mob.getHealth();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void tick() {
            if (this.mob.getTarget() == null || !this.canUseAttack) return;
            this.whileAttackTimer += 2;
            LivingEntity target = this.mob.getTarget();
            if (this.mob.getState() == 0) {
                this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                if (YellowOperaEntity.this.level().random.nextInt(100) <= 35 && this.mob.distanceTo((Entity)target) > 6.0f) {
                    this.mob.setState(1);
                } else if ((double)YellowOperaEntity.this.level().random.nextInt(100) + YellowOperaEntity.this.level().random.nextDouble() <= 50.0) {
                    if (!(this.mob.distanceTo((Entity)this.mob.getTarget()) < 8.0f)) return;
                    this.mob.setState(2);
                    this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                    for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.mob, 4.0)) {
                        this.mob.doHurtTarget((Entity)enemy);
                    }
                } else {
                    this.mob.setState(3);
                    this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                    this.mob.getNavigation().moveTo(target.getX(), target.getY(), target.getZ(), 3.0);
                    for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.mob, 3.0)) {
                        this.mob.doHurtTarget((Entity)enemy);
                    }
                }
            }
            if (this.mob.getState() == 3) {
                if (this.whileAttackTimer > 50) {
                    this.canUseAttack = false;
                }
                if (this.mob.blockPosition().getX() == (int)target.getX() && this.mob.blockPosition().getY() == (int)target.getY() && this.mob.blockPosition().getZ() == (int)target.getZ()) {
                    this.canUseAttack = false;
                }
                if (this.mob.distanceToSqr((Entity)this.mob.getTarget()) < 3.0) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.mob.getHealth()) {
                    this.canUseAttack = false;
                }
            }
            if (this.mob.getState() == 2 && this.whileAttackTimer > 20) {
                this.canUseAttack = false;
                this.mob.setState(0);
                this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
                return;
            } else {
                if (this.mob.getState() != 1) return;
                if (this.shotChargeTimer > 0) {
                    --this.shotChargeTimer;
                    this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                    ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f), this.mob.getX(), this.mob.getY() + 2.5, this.mob.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                    return;
                } else {
                    this.mob.getLookControl().setLookAt((Entity)target, 0.0f, 0.0f);
                    this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
                    if (!YellowOperaEntity.this.level().isClientSide) {
                        LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(YellowOperaEntity.this.level());
                        lightningboltentity.moveTo(target.position());
                        YellowOperaEntity.this.level().addFreshEntity((Entity)lightningboltentity);
                        target.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.LIGHTNING, (Entity)lightningboltentity, (Entity)this.mob), (float)this.mob.getAttributeValue(Attributes.ATTACK_DAMAGE));
                    }
                    if (this.whileAttackTimer <= 50) return;
                    this.shotChargeTimer = 50;
                    this.canUseAttack = false;
                    this.mob.setState(0);
                    this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
                }
            }
        }
    }
}

