/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class AssassinGoal
extends TargetGoal {
    private final int MAX_DISTANCE_FOR_AI = 100;
    private final int TIME_BEFORE_NEXT_ATTACK = 70;
    private final int TIME_TO_GO_UNDERGROUND = 120;
    private final int TIME_UNDERGROUND = 30;
    private int undergroundTicks = 70;
    private int ticksUntilNextAttack = 70;
    private int ticksToLowHealth = 70;
    private int ticksToExplode = 30;
    private boolean canUseNextAttack = true;
    private final BaseKHEntity mob;

    public AssassinGoal(PathfinderMob creature) {
        super((Mob)creature, true);
        this.mob = (BaseKHEntity)creature;
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null) {
            if (this.mob.getHealth() <= this.mob.getMaxHealth() / 4.0f) {
                if (this.isExploding()) {
                    this.ticksToExplode -= 2;
                    if (this.ticksToExplode <= 0) {
                        this.explode();
                    }
                } else {
                    this.ticksToLowHealth -= 2;
                    if (this.ticksToLowHealth <= 0) {
                        this.mob.setState(2);
                        this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                        this.mob.setInvulnerable(true);
                    }
                }
                return true;
            }
            if (this.isUnderground()) {
                this.mob.setInvulnerable(true);
                this.canUseNextAttack = false;
                if (this.mob.distanceTo((Entity)this.mob.getTarget()) < 5.0f) {
                    this.mob.doHurtTarget((Entity)this.mob.getTarget());
                } else {
                    this.mob.setState(0);
                    this.mob.setInvulnerable(false);
                    this.undergroundTicks = 120;
                    this.canUseNextAttack = true;
                }
                this.undergroundTicks += 2;
                if (this.undergroundTicks >= 30) {
                    this.mob.setState(0);
                    this.mob.setInvulnerable(false);
                    this.canUseNextAttack = true;
                }
            }
            if (this.mob.distanceTo((Entity)this.mob.getTarget()) < 5.0f) {
                if (this.mob.onGround() && !this.isUnderground()) {
                    this.undergroundTicks -= 2;
                    if (this.undergroundTicks <= 0) {
                        this.mob.setState(1);
                        this.canUseNextAttack = false;
                    }
                }
                if (!this.canUseNextAttack) {
                    this.ticksUntilNextAttack -= 2;
                    if (this.ticksUntilNextAttack <= 0) {
                        this.canUseNextAttack = true;
                        this.ticksUntilNextAttack = 70;
                    }
                }
            }
            return true;
        }
        this.mob.setState(0);
        this.mob.setInvulnerable(false);
        return false;
    }

    private void explode() {
        this.mob.level().explode((Entity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ(), 6.0f, false, Level.ExplosionInteraction.NONE);
        this.mob.remove(Entity.RemovalReason.KILLED);
    }

    public void start() {
        this.mob.setState(0);
        this.mob.setInvulnerable(false);
    }

    private boolean isUnderground() {
        return this.mob.getState() == 1;
    }

    private boolean isExploding() {
        return this.mob.getState() == 2;
    }

    public boolean canUse() {
        return this.mob.getTarget() != null && this.mob.distanceToSqr((Entity)this.mob.getTarget()) < 100.0;
    }
}

