/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import java.util.List;
import java.util.Optional;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class BlackFungusGoal
extends TargetGoal {
    private final int MAX_NO_AI_DURATION = 120;
    private final int MAX_STONE_DURATION = 200;
    private final int MAX_POISON_DURATION = 60;
    private int ticksToChooseAI = 0;
    private int stoneDuration = 0;
    private int poisonDuration = 0;

    public BlackFungusGoal(PathfinderMob creature) {
        super((Mob)creature, true);
    }

    public boolean canContinueToUse() {
        Mob mob = this.mob;
        if (mob instanceof BaseKHEntity) {
            BaseKHEntity khMob = (BaseKHEntity)mob;
            if (this.mob.getTarget() != null) {
                switch (khMob.getState()) {
                    case 0: {
                        if (this.ticksToChooseAI <= 0) {
                            int randomCharade = Utils.randomWithRange(-5, -4);
                            khMob.setState(randomCharade);
                            this.ticksToChooseAI = 120;
                            break;
                        }
                        this.ticksToChooseAI -= 2;
                        break;
                    }
                    case -4: {
                        if (this.stoneDuration <= 0) {
                            this.stoneDuration = 200;
                            khMob.setState(0);
                            break;
                        }
                        this.stoneDuration -= 2;
                        break;
                    }
                    case -5: {
                        if (this.poisonDuration <= 0) {
                            this.poisonDuration = 60;
                            khMob.setState(0);
                            this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
                            double X = this.mob.getX();
                            double Y = this.mob.getY();
                            double Z = this.mob.getZ();
                            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.mob.level(), X, Y + 0.5, Z);
                            Mob entity = this.mob;
                            if (entity instanceof LivingEntity) {
                                areaeffectcloud.setOwner((LivingEntity)entity);
                            }
                            areaeffectcloud.setRadius(3.0f);
                            areaeffectcloud.setRadiusOnUse(-0.5f);
                            areaeffectcloud.setWaitTime(10);
                            areaeffectcloud.setDuration(120);
                            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
                            areaeffectcloud.setPotionContents(new PotionContents(Optional.of(Potions.STRONG_POISON), Optional.of(0xAA00AA), List.of()));
                            for (MobEffectInstance mobeffectinstance : new PotionContents(Potions.STRONG_POISON).getAllEffects()) {
                                areaeffectcloud.addEffect(new MobEffectInstance(mobeffectinstance));
                            }
                            this.mob.level().addFreshEntity((Entity)areaeffectcloud);
                            break;
                        }
                        this.poisonDuration -= 2;
                        this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                    }
                }
                return true;
            }
            khMob.setState(0);
        }
        return false;
    }

    public void start() {
        Mob mob = this.mob;
        if (mob instanceof BaseKHEntity) {
            BaseKHEntity khMob = (BaseKHEntity)mob;
            khMob.setState(0);
        }
    }

    public boolean canUse() {
        return this.mob.getTarget() != null;
    }
}

