/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class DragoonGoal
extends TargetGoal {
    private final int MAX_BALL_TICKS = 60;
    private int ballTicks = 0;
    private final int MAX_FALL_TICKS = 20;
    private int fallTicks = 0;
    private int ticksToChooseAI = 20;
    private final BaseKHEntity mob;

    public DragoonGoal(PathfinderMob creature) {
        super((Mob)creature, true);
        this.mob = (BaseKHEntity)creature;
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null) {
            if (this.ticksToChooseAI <= 0 && this.mob.getState() == 0) {
                if ((double)this.mob.level().random.nextInt(100) + this.mob.level().random.nextDouble() <= 40.0) {
                    this.setBall(this.mob);
                    this.ticksToChooseAI = 120;
                } else {
                    this.doJump((Mob)this.mob);
                    this.ticksToChooseAI = 80;
                }
            } else if (this.mob.getState() == 0) {
                this.ticksToChooseAI -= 2;
            }
            if (this.isBall()) {
                this.ballAI();
            }
            if (this.isFalling()) {
                this.fallingAI();
            }
            return true;
        }
        this.setDefault(this.mob);
        return false;
    }

    private void doJump(Mob mob) {
        this.mob.setDeltaMovement(mob.getDeltaMovement().add(0.0, 0.8, 0.0));
        EntityHelper.Dir dir = EntityHelper.get8Directions((Entity)this.mob);
        float jumpSpeed = 1.0f;
        switch (dir) {
            case NORTH: {
                mob.setDeltaMovement(mob.getDeltaMovement().add(0.0, 0.0, (double)(-jumpSpeed)));
                break;
            }
            case NORTH_WEST: {
                mob.setDeltaMovement(mob.getDeltaMovement().add((double)(-jumpSpeed), 0.0, (double)(-jumpSpeed)));
                break;
            }
            case SOUTH: {
                mob.setDeltaMovement(mob.getDeltaMovement().add(0.0, 0.0, (double)jumpSpeed));
                break;
            }
            case NORTH_EAST: {
                mob.setDeltaMovement(mob.getDeltaMovement().add((double)jumpSpeed, 0.0, (double)(-jumpSpeed)));
                break;
            }
            case WEST: {
                mob.setDeltaMovement(mob.getDeltaMovement().add((double)(-jumpSpeed), 0.0, 0.0));
                break;
            }
            case SOUTH_WEST: {
                mob.setDeltaMovement(mob.getDeltaMovement().add((double)(-jumpSpeed), 0.0, (double)jumpSpeed));
                break;
            }
            case EAST: {
                mob.setDeltaMovement(mob.getDeltaMovement().add((double)jumpSpeed, 0.0, 0.0));
                break;
            }
            case SOUTH_EAST: {
                mob.setDeltaMovement(mob.getDeltaMovement().add((double)jumpSpeed, 0.0, (double)jumpSpeed));
            }
        }
    }

    private void ballAI() {
        this.ballTicks += 2;
        if (this.ballTicks >= 60) {
            this.setFall(this.mob);
            this.ballTicks = 0;
        }
    }

    private void fallingAI() {
        this.fallTicks += 2;
        for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.mob, 3.0)) {
            this.mob.doHurtTarget((Entity)enemy);
        }
        if (this.fallTicks >= 20) {
            this.fallTicks = 0;
            this.setDefault(this.mob);
        }
    }

    public void setFall(BaseKHEntity mob) {
        this.fallTicks = 0;
        mob.setState(2);
        mob.level().playSound(null, mob.blockPosition(), (SoundEvent)ModSounds.portal.get(), SoundSource.HOSTILE, 1.0f, 2.0f);
        mob.level().playSound(null, mob.getTarget().blockPosition(), (SoundEvent)ModSounds.portal.get(), SoundSource.HOSTILE, 1.0f, 2.0f);
        mob.teleportTo(mob.getTarget().getX(), mob.getTarget().getY() + 5.0, mob.getTarget().getZ());
        mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
    }

    public void setBall(BaseKHEntity mob) {
        this.ballTicks = 0;
        mob.setState(1);
        mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
    }

    public void setDefault(BaseKHEntity mob) {
        mob.setState(0);
        mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.27);
    }

    public void start() {
        this.mob.setState(0);
    }

    private boolean isBall() {
        return this.mob.getState() == 1;
    }

    private boolean isFalling() {
        return this.mob.getState() == 2;
    }

    public boolean canUse() {
        return this.mob.getTarget() != null;
    }
}

