/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCAeroSoundPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class EmeraldBluesGoal
extends TargetGoal {
    private final int MAX_AERO_TICKS = 300;
    private int ticksToChooseAI = 20;
    private final BaseKHEntity mob;

    public EmeraldBluesGoal(PathfinderMob creature) {
        super((Mob)creature, true);
        this.mob = (BaseKHEntity)creature;
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null) {
            if (this.mob.getState() == 1 && this.mob.hasEffect(ModMobEffects.AERO)) {
                this.mob.setState(0);
            }
            if (this.ticksToChooseAI <= 0 && this.mob.getState() == 0) {
                this.setAero(this.mob);
                this.ticksToChooseAI = 150;
            } else if (this.mob.getState() == 0) {
                this.ticksToChooseAI -= 2;
            }
            if (this.isAero()) {
                this.aeroAI();
            }
            return true;
        }
        this.mob.setState(0);
        return false;
    }

    private void aeroAI() {
        MobEffectInstance aero = this.mob.getEffect(ModMobEffects.AERO);
        switch (aero.getAmplifier()) {
            case 0: {
                break;
            }
            case 1: {
                for (LivingEntity enemy : Utils.getLivingEntitiesInRadius((Entity)this.mob, 1.0f)) {
                    enemy.hurt(enemy.damageSources().mobAttack((LivingEntity)this.mob), (float)this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue() * 0.03f);
                }
                break;
            }
            case 2: {
                for (LivingEntity enemy : Utils.getLivingEntitiesInRadius((Entity)this.mob, 1.2f)) {
                    enemy.hurt(enemy.damageSources().mobAttack((LivingEntity)this.mob), (float)this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue() * 0.04f);
                }
                break;
            }
        }
    }

    public void setAero(BaseKHEntity mob) {
        mob.addEffect(new MobEffectInstance(ModMobEffects.AERO, 300, 1, false, false, false));
        mob.setState(1);
        PacketHandler.sendToAll(new SCAeroSoundPacket(this.mob.getId()));
    }

    public void start() {
        this.mob.setState(0);
    }

    private boolean isAero() {
        return this.mob.getState() == 1;
    }

    public boolean canUse() {
        return this.mob.getTarget() != null;
    }
}

