/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.MarluxiaEntity;
import org.joml.Vector3f;

public class MarluxiaGoal
extends TargetGoal {
    private final BaseKHEntity mob;
    private final int MAX_ARMOR_TICKS = 600;
    private final int MAX_ARMOR_USES = 3;
    private int armorTicks = 0;
    private int armorUses = 0;
    private final int MAX_TP_TICKS = 80;
    private int tpTicks = 0;
    public int chasingTicks = 0;
    public int chasedTimes = 0;
    private int ticksToChooseAI = 200;
    double posX;
    double posY;
    double posZ;

    public MarluxiaGoal(PathfinderMob creature) {
        super((Mob)creature, true);
        this.mob = (BaseKHEntity)creature;
    }

    public boolean canContinueToUse() {
        if (this.mob.tickCount < 100) {
            this.mob.setDeltaMovement(0.0, 0.0, 0.0);
            this.mob.setInvulnerable(true);
            this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0.0);
        }
        if (this.mob.tickCount >= 100 && this.mob.tickCount <= 101) {
            this.mob.setInvulnerable(false);
            this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(11.0);
        }
        if (this.mob.getTarget() != null) {
            if (this.ticksToChooseAI <= 0 && this.mob.getState() == 0) {
                int n = this.mob.level().random.nextInt() * 100;
                if (n < 50) {
                    if ((double)this.mob.getHealth() < (double)this.mob.getMaxHealth() * 0.8 && !this.isArmored()) {
                        this.useArmor((MarluxiaEntity)this.mob, false);
                        this.ticksToChooseAI = 200;
                    } else {
                        this.ticksToChooseAI = 100;
                    }
                } else {
                    this.useTP((MarluxiaEntity)this.mob);
                    this.ticksToChooseAI = 150;
                }
            } else if (this.mob.getState() == 0) {
                this.ticksToChooseAI -= 2;
            }
            if (this.isArmored()) {
                this.armoredAI();
            }
            if (this.isTeleporting()) {
                this.teleportAI();
            }
            if (this.isChasing()) {
                this.chasingAI();
            }
            return true;
        }
        if (ModConfigs.bossDespawnIfNoTarget) {
            this.mob.remove(Entity.RemovalReason.KILLED);
        } else {
            if (this.mob.isNoGravity()) {
                this.mob.setNoGravity(false);
            }
            if (this.mob.getState() == 0) {
                this.mob.setState(0);
            }
        }
        return false;
    }

    private void teleportAI() {
        this.mob.setNoGravity(true);
        if (this.tpTicks % 20 == 0) {
            this.attackWithTP();
        }
        if (this.tpTicks > 80) {
            this.mob.setNoGravity(false);
            this.mob.setState(0);
        }
        this.tpTicks += 2;
    }

    private void armoredAI() {
        if (this.armorTicks <= 40) {
            this.mob.setDeltaMovement(0.0, 0.2, 0.0);
            this.mob.setInvulnerable(true);
        } else if (this.armorTicks < 45) {
            this.mob.setDeltaMovement(0.0, -100.0, 0.0);
        }
        if (this.armorTicks == 48) {
            this.posX = this.mob.getX();
            this.posY = this.mob.getY();
            this.posZ = this.mob.getZ();
            this.mob.setInvulnerable(false);
        }
        if (this.armorTicks > 48 && this.armorTicks < 70) {
            double r = (double)(this.armorTicks - 48) * 0.7;
            for (int a = 1; a <= 360; a += 7) {
                double x = this.posX + r * Math.cos(Math.toRadians(a));
                double z = this.posZ + r * Math.sin(Math.toRadians(a));
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.9f, 0.9f), 1.0f), x, this.posY + 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            AABB aabb = new AABB(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).inflate(r, 0.0, r);
            List list = this.mob.level().getEntitiesOfClass(LivingEntity.class, aabb);
            list.remove(this.mob);
            for (LivingEntity enemy : list) {
                this.mob.doHurtTarget((Entity)enemy);
            }
        }
        this.armorTicks += 2;
        if (this.armorTicks >= 600) {
            this.removeArmor((MarluxiaEntity)this.mob);
            this.armorTicks = 0;
        }
    }

    private void chasingAI() {
        if (this.chasingTicks <= 40) {
            this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0.0);
            this.mob.setDeltaMovement(0.0, 0.2, 0.0);
            this.mob.setInvulnerable(true);
        } else if (this.chasingTicks < 300) {
            this.mob.absMoveTo(this.mob.getTarget().getX(), this.mob.getTarget().getY(), this.mob.getTarget().getZ(), this.mob.getTarget().getYRot(), this.mob.getTarget().getYRot());
            RandomSource rand = this.mob.level().getRandom();
            ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.6f, 0.6f), 1.0f), this.mob.getX() - 1.0 + rand.nextDouble() * 2.0, this.mob.getY(), this.mob.getZ() - 1.0 + rand.nextDouble() * 2.0, 10, 0.0, 0.0, 0.0, 100.0);
            if (this.chasingTicks % 10 == 0) {
                boolean r = true;
                double pX = this.mob.getTarget().getX() - 3.0 + rand.nextDouble() * 6.0;
                double pY = this.mob.getTarget().getY();
                double pZ = this.mob.getTarget().getZ() - 3.0 + rand.nextDouble() * 6.0;
                this.mob.level().playSound(null, new BlockPos((int)pX, (int)pY, (int)pZ), (SoundEvent)ModSounds.portal.get(), SoundSource.MASTER, 1.0f, 1.0f);
                for (double i = 0.0; i < 4.0; i += 0.5) {
                    for (int a = 1; a <= 360; a += 7) {
                        double x = pX + (double)r * Math.cos(Math.toRadians(a));
                        double z = pZ + (double)r * Math.sin(Math.toRadians(a));
                        ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.5f), 1.0f), x, pY + i, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                AABB aabb = new AABB(pX, pY, pZ, pX + 1.0, pY + 1.0, pZ + 1.0).inflate((double)r, 4.0, (double)r);
                List list = this.mob.level().getEntitiesOfClass(LivingEntity.class, aabb);
                list.remove(this.mob);
                for (LivingEntity enemy : list) {
                    enemy.hurt(enemy.damageSources().magic(), 3.0f);
                }
            }
        } else if (this.chasingTicks >= 300) {
            this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(11.0);
            this.useArmor((MarluxiaEntity)this.mob, true);
        }
        this.chasingTicks += 2;
    }

    private void attackWithTP() {
        RandomSource rand = this.mob.level().getRandom();
        for (int i = 0; i < 10; ++i) {
            ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.6f, 0.6f), 1.0f), this.mob.getX() - 2.0 + rand.nextDouble() * 4.0, this.mob.getY() + rand.nextDouble() * 4.0, this.mob.getZ() - 2.0 + rand.nextDouble() * 4.0, 10, 0.0, 0.0, 0.0, 100.0);
        }
        this.mob.teleportTo(this.mob.getTarget().getX(), this.mob.getTarget().getY() + 1.0, this.mob.getTarget().getZ());
        if (this.mob.getTarget().distanceTo((Entity)this.mob) <= 1.0f) {
            if (this.mob.getTarget() instanceof Player) {
                this.mob.getTarget().travel(new Vec3(0.0, 2.0, 0.0));
            }
            this.mob.getTarget().setDeltaMovement(0.0, 1.2, 0.0);
            this.mob.getTarget().hurt(this.mob.getTarget().damageSources().magic(), 2.0f);
        } else {
            this.mob.setState(0);
        }
    }

    public void useArmor(MarluxiaEntity entity, boolean ignoreRestriction) {
        if (this.armorUses < 3 || ignoreRestriction) {
            this.armorTicks = 0;
            entity.setState(1);
            entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 2000, 200));
            ++this.armorUses;
        }
    }

    public void removeArmor(MarluxiaEntity entity) {
        entity.setState(0);
        entity.removeEffect(MobEffects.GLOWING);
    }

    public void useTP(MarluxiaEntity entity) {
        entity.setState(2);
        this.tpTicks = 0;
    }

    public void start() {
        this.mob.setState(0);
        this.mob.setInvulnerable(false);
    }

    private boolean isArmored() {
        return this.mob.getState() == 1;
    }

    private boolean isTeleporting() {
        return this.mob.getState() == 2;
    }

    private boolean isChasing() {
        return this.mob.getState() == 3;
    }

    public boolean canUse() {
        return this.mob.getTarget() != null;
    }
}

