/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class ShadowGoal
extends TargetGoal {
    private final int MAX_DISTANCE_FOR_AI = 100;
    private final int MAX_DISTANCE_FOR_LEAP = 10;
    private final int MAX_DISTANCE_FOR_DASH = 25;
    private final int TIME_BEFORE_NEXT_ATTACK = 70;
    private final int TIME_OUTSIDE_THE_SHADOW = 70;
    private int shadowTicks = 70;
    private int oldAi = -1;
    private int ticksUntilNextAttack = 70;
    public boolean canUseNextAttack = true;
    public double originalAttackDamage;
    private final BaseKHEntity mob;

    public ShadowGoal(PathfinderMob creature) {
        super((Mob)creature, true);
        this.originalAttackDamage = creature.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
        this.mob = (BaseKHEntity)creature;
    }

    public boolean canContinueToUse() {
        if (this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue() > 0.0) {
            this.originalAttackDamage = this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
        }
        if (this.mob.getTarget() != null && this.mob.distanceToSqr((Entity)this.mob.getTarget()) < 100.0) {
            if (this.mob.onGround() && !this.isInShadow()) {
                this.shadowTicks -= 2;
                if (this.shadowTicks <= 0) {
                    this.mob.setState(1);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0.0);
                    this.canUseNextAttack = false;
                }
            }
            if (this.isInShadow()) {
                this.mob.setInvulnerable(true);
                this.canUseNextAttack = false;
                this.shadowTicks += 2;
                if (this.shadowTicks >= 70) {
                    this.mob.setState(0);
                    this.mob.setInvulnerable(false);
                    this.canUseNextAttack = true;
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.originalAttackDamage);
                }
            }
            EntityHelper.Dir dir = EntityHelper.get8Directions((Entity)this.mob);
            int currentAi = this.mob.level().random.nextInt(2);
            if (!this.canUseNextAttack) {
                this.ticksUntilNextAttack -= 2;
                if (this.ticksUntilNextAttack <= 0) {
                    this.canUseNextAttack = true;
                    this.ticksUntilNextAttack = 70;
                }
            }
            if (this.oldAi != -1 && this.canUseNextAttack) {
                if (currentAi == 0 && this.oldAi == 0) {
                    currentAi = 1;
                }
                if (currentAi == 1 && this.oldAi == 1) {
                    currentAi = 0;
                }
            }
            if (this.mob.onGround() && this.mob.distanceToSqr((Entity)this.mob.getTarget()) <= 10.0 && currentAi == 0 && this.canUseNextAttack) {
                this.oldAi = 0;
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.5, 0.0));
                switch (dir) {
                    case NORTH: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.0, -0.7));
                        break;
                    }
                    case NORTH_WEST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-0.7, 0.0, -0.7));
                        break;
                    }
                    case SOUTH: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.0, 0.7));
                        break;
                    }
                    case NORTH_EAST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.7, 0.0, -0.7));
                        break;
                    }
                    case WEST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-0.7, 0.0, 0.0));
                        break;
                    }
                    case SOUTH_WEST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-0.7, 0.0, 0.7));
                        break;
                    }
                    case EAST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.7, 0.0, 0.0));
                        break;
                    }
                    case SOUTH_EAST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.7, 0.0, 0.7));
                    }
                }
                if (this.mob.level().random.nextInt(2) == 0) {
                    this.mob.setState(0);
                    this.mob.setInvulnerable(false);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.originalAttackDamage);
                } else {
                    this.mob.setState(1);
                    this.mob.setInvulnerable(true);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0.0);
                }
                this.canUseNextAttack = false;
            }
            if (this.mob.onGround() && this.mob.distanceToSqr((Entity)this.mob.getTarget()) <= 25.0 && currentAi == 1 && this.canUseNextAttack) {
                this.oldAi = 1;
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.2, 0.0));
                switch (dir) {
                    case NORTH: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.0, -1.0));
                        break;
                    }
                    case NORTH_WEST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-1.0, 0.0, -1.0));
                        break;
                    }
                    case SOUTH: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.0, 1.0));
                        break;
                    }
                    case NORTH_EAST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(1.0, 0.0, -1.0));
                        break;
                    }
                    case WEST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-1.0, 0.0, 0.0));
                        break;
                    }
                    case SOUTH_WEST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-1.0, 0.0, 1.0));
                        break;
                    }
                    case EAST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(1.0, 0.0, 0.0));
                        break;
                    }
                    case SOUTH_EAST: {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(1.0, 0.0, 1.0));
                    }
                }
                if (this.mob.level().random.nextInt(2) == 0) {
                    this.mob.setState(0);
                    this.mob.setInvulnerable(false);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.originalAttackDamage);
                } else {
                    this.mob.setState(1);
                    this.mob.setInvulnerable(true);
                    this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(0.0);
                }
                this.canUseNextAttack = false;
            }
            return true;
        }
        this.mob.setState(0);
        this.mob.setInvulnerable(false);
        this.mob.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(this.originalAttackDamage);
        return false;
    }

    public void start() {
        this.mob.setState(0);
        this.mob.setInvulnerable(false);
    }

    public boolean isInShadow() {
        return this.mob.getState() == 1;
    }

    public boolean canUse() {
        return this.mob.getTarget() != null && this.mob.distanceToSqr((Entity)this.mob.getTarget()) < 100.0;
    }
}

