/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.phys.AABB;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class SoldierGoal
extends TargetGoal {
    private final int MAX_SPINNING_TICKS = 40;
    private int spinTicks = 0;
    private int ticksToChooseAI = 20;
    private final BaseKHEntity mob;

    public SoldierGoal(PathfinderMob creature) {
        super((Mob)creature, true);
        this.mob = (BaseKHEntity)creature;
    }

    public boolean canContinueToUse() {
        if (this.mob.getTarget() != null) {
            if (this.ticksToChooseAI <= 0 && this.mob.getState() == 0) {
                this.setSpinning(this.mob);
                this.ticksToChooseAI = 150;
            } else if (this.mob.getState() == 0) {
                this.ticksToChooseAI -= 2;
            }
            if (this.isSpinning()) {
                this.spinningAI();
            }
            return true;
        }
        this.mob.setState(0);
        return false;
    }

    private void spinningAI() {
        this.spinTicks += 2;
        double r = 1.5;
        AABB aabb = new AABB(this.mob.position().x, this.mob.position().y, this.mob.position().z, this.mob.position().x + 1.0, this.mob.position().y + 1.0, this.mob.position().z + 1.0).inflate(r, 0.0, r);
        List list = this.mob.level().getEntitiesOfClass(LivingEntity.class, aabb);
        list.remove(this.mob);
        for (LivingEntity enemy : list) {
            this.mob.doHurtTarget((Entity)enemy);
        }
        if (this.spinTicks >= 40) {
            this.mob.setState(0);
            this.spinTicks = 0;
        }
    }

    public void setSpinning(BaseKHEntity mob) {
        this.spinTicks = 0;
        mob.setState(1);
    }

    public void start() {
        this.mob.setState(0);
    }

    private boolean isSpinning() {
        return this.mob.getState() == 1;
    }

    public boolean canUse() {
        return this.mob.getTarget() != null;
    }
}

