/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import online.kingdomkeys.kingdomkeys.entity.mob.WhiteMushroomEntity;

public class WhiteMushroomGoal
extends Goal {
    private final WhiteMushroomEntity mob;
    private final int MAX_NO_CHARADE_DURATION = 120;
    private final int MAX_CHARADE_DURATION = 80;
    private int charadeDuration = 0;
    private int ticksToChooseCharade = 0;

    public WhiteMushroomGoal(WhiteMushroomEntity creature) {
        this.mob = creature;
        this.ticksToChooseCharade = 0;
        this.mob.setState(0);
    }

    public boolean canContinueToUse() {
        return true;
    }

    public void start() {
        this.mob.setState(0);
    }

    public boolean canUse() {
        return true;
    }

    public void tick() {
        switch (this.getCharade(this.mob)) {
            case 0: {
                if (this.ticksToChooseCharade <= 0) {
                    int randomCharade = this.mob.level().getRandom().nextInt(3) + 1;
                    this.setCharade(this.mob, randomCharade);
                    this.ticksToChooseCharade = 120;
                    break;
                }
                this.ticksToChooseCharade -= 2;
                break;
            }
            case -1: {
                if (this.charadeDuration <= -80) {
                    this.charadeDuration = 80;
                    this.setCharade(this.mob, 0);
                    break;
                }
                this.charadeDuration -= 2;
                break;
            }
            case -2: {
                if (this.charadeDuration <= 0) {
                    this.charadeDuration = 80;
                    this.mob.remove(Entity.RemovalReason.KILLED);
                    break;
                }
                this.charadeDuration -= 4;
                break;
            }
            case -3: {
                if (this.charadeDuration <= 0) {
                    this.charadeDuration = 80;
                    this.mob.remove(Entity.RemovalReason.KILLED);
                    break;
                }
                this.charadeDuration -= 2;
                break;
            }
            default: {
                if (this.charadeDuration <= 0) {
                    this.setCharade(this.mob, 0);
                    this.charadeDuration = 80;
                    break;
                }
                this.charadeDuration -= 2;
            }
        }
        super.tick();
    }

    public void setCharade(WhiteMushroomEntity mob, int charadeID) {
        mob.setState(charadeID);
    }

    public int getCharade(WhiteMushroomEntity mob) {
        return mob.getState();
    }
}

