/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;

public class ArrowRainCoreEntity
extends ThrowableProjectile {
    int maxTicks = 240;
    float dmg;
    float radius;
    float space;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(ArrowRainCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> TARGET = SynchedEntityData.defineId(ArrowRainCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public ArrowRainCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public ArrowRainCoreEntity(Level world, Player player, LivingEntity target, float dmg) {
        super(ModEntities.TYPE_ARROW_RAIN.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        this.setTarget(target.getUUID());
        this.dmg = dmg;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks || this.getCaster() == null) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.hurtMarked = true;
        double X = this.getX();
        double Y = this.getY();
        double Z = this.getZ();
        if (this.getCaster() != null) {
            if (this.tickCount == 1) {
                LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.level(), (LivingEntity)this.getCaster(), this.dmg);
                bullet.setPos(X, Y, Z);
                bullet.setMaxTicks(30);
                bullet.shoot(0.0, 255.0, 0.0, 1.0f, 0.0f);
                this.level().addFreshEntity((Entity)bullet);
                this.level().playSound(this.getCaster(), this.getCaster().blockPosition(), (SoundEvent)ModSounds.sharpshooterbullet.get(), SoundSource.PLAYERS, 1.0f, 0.6f);
            } else if (this.tickCount > 40 && this.tickCount % 2 == 0) {
                this.radius = Math.min((float)(this.tickCount - 34) / 10.0f, 20.0f);
                this.space = 26.0f - this.radius;
                int s = 1;
                while (s < 360) {
                    double x = X + (double)this.radius * Math.cos(Math.toRadians(s));
                    double z = Z + (double)this.radius * Math.sin(Math.toRadians(s));
                    LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.level(), (LivingEntity)this.getCaster(), this.dmg);
                    bullet.setPos(X, Y + 27.0, Z);
                    bullet.setMaxTicks(20);
                    bullet.shoot(x - bullet.getX(), this.getY() - bullet.getY() + 1.0, z - bullet.getZ(), 2.5f, 0.0f);
                    this.level().addFreshEntity((Entity)bullet);
                    s = (int)((float)s + this.space);
                }
                this.level().playSound(this.getCaster(), this.getCaster().blockPosition(), (SoundEvent)ModSounds.sharpshooterbullet.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
        this.remove(Entity.RemovalReason.KILLED);
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
            compound.putString("TargetUUID", ((UUID)((Optional)this.entityData.get(TARGET)).get()).toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
        this.entityData.set(TARGET, Optional.of(UUID.fromString(compound.getString("TargetUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public Player getTarget() {
        return ((Optional)this.getEntityData().get(TARGET)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.entityData.set(TARGET, Optional.of(uuid));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(new UUID(0L, 0L)));
        pBuilder.define(TARGET, Optional.of(new UUID(0L, 0L)));
    }
}

