/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class ArrowgunShotEntity
extends ThrowableProjectile {
    int maxTicks = 120;
    float dmg;
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(ArrowgunShotEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    int type = 0;

    public ArrowgunShotEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public ArrowgunShotEntity(Level world, LivingEntity player, float damage, double x, double y, double z) {
        this(world, player, damage);
        this.setPos(x, y, z);
    }

    public ArrowgunShotEntity(Level world, LivingEntity player, float damage) {
        super(ModEntities.TYPE_ARROWGUN_SHOT.get(), player, world);
        this.dmg = damage;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        float f;
        HitResult hitresult;
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount > 1 && this.getShotType() == 1) {
            this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        if ((hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.setDeltaMovement(vec3.scale((double)f));
        this.applyGravity();
        this.setPos(d0, d1, d2);
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && (entity = ertResult.getEntity()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (target != this.getOwner()) {
                    target.invulnerableTime = 0;
                    target.hurt(target.damageSources().thrown((Entity)this, this.getOwner()), this.dmg);
                    this.remove(Entity.RemovalReason.KILLED);
                }
            } else {
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(TYPE)) {
            this.type = (Integer)this.entityData.get(TYPE);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Type", this.getShotType());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setShotType(compound.getInt("Type"));
    }

    public int getShotType() {
        return this.type;
    }

    public void setShotType(int type) {
        this.entityData.set(TYPE, (Object)type);
        this.type = type;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(TYPE, (Object)0);
    }
}

