/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.CardItem;
import online.kingdomkeys.kingdomkeys.item.organization.ChakramItem;
import online.kingdomkeys.kingdomkeys.item.organization.KnifeItem;
import online.kingdomkeys.kingdomkeys.item.organization.ScytheItem;

public class KKThrowableEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Integer> ROTATION_POINT = SynchedEntityData.defineId(KKThrowableEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    Set<LivingEntity> hitSet = new HashSet<LivingEntity>();
    public int slot;
    public UUID ownerUUID;
    int maxTicks = 120;
    boolean returning = false;
    float dmg;
    Player owner;
    int rotationPoint;

    public KKThrowableEntity(Level world) {
        super(ModEntities.TYPE_KK_THROWABLE.get(), world);
        this.blocksBuilding = true;
    }

    public KKThrowableEntity(EntityType<? extends ThrowableItemProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public void setData(float damage, UUID ownerUUID, int slot, ItemStack stack) {
        this.dmg = damage;
        this.ownerUUID = ownerUUID;
        this.slot = slot;
        this.setItem(stack);
    }

    public Player getProjOwner() {
        if (this.owner == null && !this.level().isClientSide) {
            this.owner = (Player)((ServerLevel)this.level()).getEntity(this.ownerUUID);
        }
        return this.owner;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getProjOwner() == null) {
                this.remove(Entity.RemovalReason.KILLED);
                return;
            }
            if (this.tickCount > this.maxTicks) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            if (this.getItem().getItem() instanceof KnifeItem) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getX(), this.getY() + (double)0.3f, this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.tickCount > 30) {
                this.setReturn();
            }
            if (Math.max(Math.abs(this.getDeltaMovement().x), Math.max(Math.abs(this.getDeltaMovement().y), Math.abs(this.getDeltaMovement().z))) < 0.1) {
                this.setReturn();
            }
            if (this.returning) {
                List entityTagetList = this.level().getEntitiesOfClass(Entity.class, this.getBoundingBox().inflate(1.0, 1.0, 1.0));
                for (Entity entity : entityTagetList) {
                    Player player;
                    if (entity == null || !(entity instanceof Player) || (player = (Player)entity) != this.getProjOwner()) continue;
                    this.remove(Entity.RemovalReason.KILLED);
                    this.returnItemToPlayer();
                    player.getCooldowns().addCooldown(this.getItem().getItem(), 20);
                }
            }
        }
    }

    public void setReturn() {
        this.hitSet.clear();
        if (this.getItem().getItem() instanceof KeybladeItem) {
            this.remove(Entity.RemovalReason.KILLED);
        } else if (this.getItem().getItem() instanceof ChakramItem) {
            this.returning = true;
            if (this.getProjOwner() != null) {
                this.shoot(this.getProjOwner().getX() - this.getX(), this.getProjOwner().getY() - this.getY() + 1.25, this.getProjOwner().getZ() - this.getZ(), 2.0f, 0.0f);
            }
        } else if (this.getItem().getItem() instanceof ScytheItem) {
            this.remove(Entity.RemovalReason.KILLED);
            this.returnItemToPlayer();
        } else if (this.getItem().getItem() instanceof KnifeItem) {
            this.remove(Entity.RemovalReason.KILLED);
            this.returnItemToPlayer();
        } else if (this.getItem().getItem() instanceof CardItem) {
            this.remove(Entity.RemovalReason.KILLED);
            this.returnItemToPlayer();
        }
    }

    private void returnItemToPlayer() {
        if (this.owner == null) {
            return;
        }
        if (!ItemStack.isSameItem((ItemStack)this.owner.getInventory().getItem(this.slot), (ItemStack)this.getItem())) {
            if (!ItemStack.isSameItem((ItemStack)this.owner.getInventory().getItem(this.slot), (ItemStack)ItemStack.EMPTY)) {
                this.owner.addItem(this.getItem());
            } else {
                this.owner.getInventory().add(this.slot, this.getItem());
            }
        }
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && ertResult.getEntity() != null && (entity = ertResult.getEntity()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (target != this.getProjOwner() && !this.hitSet.contains(target)) {
                    this.hitSet.add(target);
                    target.invulnerableTime = 0;
                    target.hurt(target.damageSources().thrown((Entity)this, (Entity)this.getProjOwner()), this.dmg < 4.0f ? 4.0f : this.dmg);
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
                    this.dmg *= 1.2f;
                }
            } else if (brtResult != null && this.level().getBlockState(brtResult.getBlockPos()).getBlock() != Blocks.TALL_GRASS && this.level().getBlockState(brtResult.getBlockPos()).getBlock() != Blocks.GRASS_BLOCK && this.level().getBlockState(brtResult.getBlockPos()).getBlock() != Blocks.SUGAR_CANE && this.level().getBlockState(brtResult.getBlockPos()).getBlock() != Blocks.VINE) {
                this.setReturn();
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(ROTATION_POINT)) {
            this.rotationPoint = (Integer)this.entityData.get(ROTATION_POINT);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.ownerUUID != null) {
            compound.putUUID("ownerUUID", this.ownerUUID);
        }
        compound.putInt("Rotation", this.getRotationPoint());
        compound.putInt("slot", this.slot);
        compound.putFloat("damage", this.dmg);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("ownerUUID")) {
            this.ownerUUID = compound.getUUID("ownerUUID");
            this.owner = this.getProjOwner();
        }
        this.setRotationPoint(compound.getInt("Rotation"));
        this.slot = compound.getInt("slot");
        this.dmg = compound.getFloat("damage");
    }

    public int getRotationPoint() {
        return this.rotationPoint;
    }

    public void setRotationPoint(int rotations) {
        this.entityData.set(ROTATION_POINT, (Object)rotations);
        this.rotationPoint = rotations;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ROTATION_POINT, (Object)0);
    }

    protected Item getDefaultItem() {
        return Items.EGG;
    }
}

