/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.organization.KKThrowableEntity;

public class LanceEntity
extends KKThrowableEntity {
    int maxTicks = 100;
    boolean stopped = false;
    private static final EntityDataAccessor<Boolean> STOPPED = SynchedEntityData.defineId(LanceEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public LanceEntity(EntityType<? extends ThrowableItemProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public LanceEntity(Level world) {
        super(ModEntities.TYPE_LANCE.get(), world);
        this.blocksBuilding = true;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.0;
    }

    @Override
    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (!this.isStopped()) {
            if (this.tickCount > 2) {
                this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
            if (this.onGround()) {
                this.setOnGround(false);
                this.setDeltaMovement(this.getDeltaMovement().multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
            }
            HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            boolean flag = false;
            if (raytraceresult.getType() == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)raytraceresult).getBlockPos();
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (blockstate.is(Blocks.NETHER_PORTAL) || blockstate.is(Blocks.END_GATEWAY)) {
                    this.handlePortal();
                    flag = true;
                } else {
                    this.setStopped(true);
                }
            }
            if (raytraceresult.getType() != HitResult.Type.MISS && !flag && !((ProjectileImpactEvent)NeoForge.EVENT_BUS.post((Event)new ProjectileImpactEvent((Projectile)this, raytraceresult))).isCanceled()) {
                this.onHit(raytraceresult);
            }
            if (!this.stopped) {
                float f1;
                Vec3 vec3d = this.getDeltaMovement();
                double d0 = this.getX() + vec3d.x;
                double d1 = this.getY() + vec3d.y;
                double d2 = this.getZ() + vec3d.z;
                if (this.isInWater()) {
                    for (int i = 0; i < 4; ++i) {
                        this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3d.x * 0.25, d1 - vec3d.y * 0.25, d2 - vec3d.z * 0.25, vec3d.x, vec3d.y, vec3d.z);
                    }
                    f1 = 0.8f;
                } else {
                    f1 = 0.99f;
                }
                this.setDeltaMovement(vec3d.scale((double)f1));
                if (!this.isNoGravity()) {
                    Vec3 vec3d1 = this.getDeltaMovement();
                    this.setDeltaMovement(vec3d1.x, vec3d1.y - this.getGravity(), vec3d1.z);
                }
                this.setPos(d0, d1, d2);
            }
        }
    }

    public void stopLance() {
        this.setStopped(true);
        this.setDeltaMovement(this.getDeltaMovement().scale(0.001));
    }

    @Override
    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && ertResult.getEntity() != null && (entity = ertResult.getEntity()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (target != this.getOwner()) {
                    target.hurt(target.damageSources().thrown((Entity)this, (Entity)this.getProjOwner()), this.dmg < 4.0f ? 4.0f : this.dmg);
                    this.dmg *= 0.9f;
                }
            } else if (brtResult != null && this.level().getBlockState(brtResult.getBlockPos()).getBlock() != Blocks.TALL_GRASS && this.level().getBlockState(brtResult.getBlockPos()).getBlock() != Blocks.GRASS_BLOCK && this.level().getBlockState(brtResult.getBlockPos()).getBlock() != Blocks.SUGAR_CANE) {
                this.stopLance();
            }
        }
    }

    @Override
    public int getMaxTicks() {
        return this.maxTicks;
    }

    @Override
    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.entityData.set(STOPPED, (Object)stopped);
        this.stopped = stopped;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(STOPPED)) {
            this.stopped = this.getStoppedDataManager();
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Stopped", this.isStopped());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setStopped(compound.getBoolean("Stopped"));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(STOPPED, (Object)false);
    }

    public boolean getStoppedDataManager() {
        return (Boolean)this.entityData.get(STOPPED);
    }
}

