/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.drops.ItemDropEntity;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class LaserCircleCoreEntity
extends ThrowableProjectile {
    int maxTicks = 70;
    List<LaserDomeShotEntity> list = new ArrayList<LaserDomeShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    Set<Integer> usedIndexes = new HashSet<Integer>();
    float dmg;
    float radius = 4.0f;
    int space;
    int shotsPerTick;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(LaserCircleCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> TARGET = SynchedEntityData.defineId(LaserCircleCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public LaserCircleCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public LaserCircleCoreEntity(Level world, Player player, LivingEntity target, float dmg) {
        super(ModEntities.TYPE_LASER_CIRCLE.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        this.setTarget(target.getUUID());
        this.dmg = dmg;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks || this.getCaster() == null) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        double X = this.getX();
        double Y = this.getY();
        double Z = this.getZ();
        if (this.getCaster() != null) {
            if (this.tickCount >= 0 && this.tickCount <= 40 && this.tickCount % 2 == 0) {
                double x = X + (double)this.radius * Math.cos(Math.toRadians(this.tickCount * 9));
                double z = Z + (double)this.radius * Math.sin(Math.toRadians(this.tickCount * 9));
                LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.level(), (LivingEntity)this.getCaster(), this.dmg);
                bullet.setPos(x, Y + 1.0, z);
                bullet.setMaxTicks(this.maxTicks);
                bullet.shoot(this.getX() - bullet.getX(), this.getY() - bullet.getY() + 1.0, this.getZ() - bullet.getZ(), 0.001f, 0.0f);
                this.level().playSound(this.getCaster(), this.getCaster().blockPosition(), (SoundEvent)ModSounds.laser.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                this.list.add(bullet);
                this.level().addFreshEntity((Entity)bullet);
                this.setDeltaMovement(0.0, 0.0, 0.0);
                this.hurtMarked = true;
            } else if (this.tickCount == 60) {
                if (this.level().isClientSide()) {
                    return;
                }
                this.updateList();
                if (this.targetList.size() > 1) {
                    this.targetList.remove((Object)this);
                }
                int targetIndex = this.random.nextInt(this.targetList.size());
                Entity target = this.targetList.get(targetIndex);
                for (LaserDomeShotEntity bullet : this.list) {
                    if (target == null || !target.isAlive() || this.getCaster() == null) continue;
                    bullet.shoot(target.getX() - bullet.getX(), target.getY() - bullet.getY() + 1.0, target.getZ() - bullet.getZ(), 1.5f, 0.0f);
                }
                this.level().playSound(this.getCaster(), this.getCaster().blockPosition(), (SoundEvent)ModSounds.laser.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        super.tick();
    }

    private void updatePos(float r) {
        for (LaserDomeShotEntity shot : this.list) {
            double x = this.getX() + (double)r * Math.cos(Math.toRadians(shot.tickCount * 9));
            double z = this.getZ() + (double)r * Math.sin(Math.toRadians(shot.tickCount * 9));
            shot.setPos(x, this.getY() + 1.0, z);
            shot.shoot(this.getX() - shot.getX(), this.getY() - shot.getY(), this.getZ() - shot.getZ(), 0.001f, 0.0f);
        }
    }

    private void updateList() {
        List tempList = this.level().getEntities((Entity)this.getCaster(), this.getBoundingBox().inflate((double)this.radius, (double)this.radius, (double)this.radius));
        Party casterParty = WorldData.get(this.level().getServer()).getPartyFromMember(this.getCaster().getUUID());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                tempList.remove(this.level().getPlayerByUUID(m.getUUID()));
            }
        } else {
            tempList.remove(this.getOwner());
        }
        this.targetList.clear();
        for (Entity t : tempList) {
            if (t instanceof LaserDomeShotEntity || t instanceof ItemDropEntity || t instanceof ItemEntity || t instanceof ExperienceOrb) continue;
            this.targetList.add(t);
        }
    }

    protected void onHit(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
            compound.putString("TargetUUID", ((UUID)((Optional)this.entityData.get(TARGET)).get()).toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
        this.entityData.set(TARGET, Optional.of(UUID.fromString(compound.getString("TargetUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public Player getTarget() {
        return ((Optional)this.getEntityData().get(TARGET)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.entityData.set(TARGET, Optional.of(uuid));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(new UUID(0L, 0L)));
        pBuilder.define(TARGET, Optional.of(new UUID(0L, 0L)));
    }
}

