/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.drops.ItemDropEntity;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class LaserDomeCoreEntity
extends ThrowableProjectile {
    int maxTicks = 240;
    List<LaserDomeShotEntity> list = new ArrayList<LaserDomeShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    Set<Integer> usedIndexes = new HashSet<Integer>();
    float dmg;
    float radius = 15.0f;
    int space = 12;
    int shotsPerTick = 3;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(LaserDomeCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> TARGET = SynchedEntityData.defineId(LaserDomeCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public LaserDomeCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public LaserDomeCoreEntity(Level world, Player player, LivingEntity target, float dmg) {
        super(ModEntities.TYPE_LASER_DOME.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        this.setTarget(target.getUUID());
        this.dmg = dmg;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks || this.getCaster() == null) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        double X = this.getX();
        double Y = this.getY();
        double Z = this.getZ();
        if (this.getCaster() != null) {
            if (this.tickCount >= 0 && this.tickCount < 20) {
                double t = this.tickCount * 5;
                for (int s = 1; s < 360; s += this.space) {
                    double x = X + (double)this.radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = Z + (double)this.radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = Y + (double)this.radius * Math.cos(Math.toRadians(t));
                    LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.level(), (LivingEntity)this.getCaster(), this.dmg);
                    bullet.setPos(x, y, z);
                    bullet.setMaxTicks(this.maxTicks - 20);
                    bullet.shoot(this.getX() - bullet.getX(), this.getY() - bullet.getY(), this.getZ() - bullet.getZ(), 0.001f, 0.0f);
                    this.list.add(bullet);
                    this.level().addFreshEntity((Entity)bullet);
                }
                this.setDeltaMovement(0.0, 0.0, 0.0);
                this.hurtMarked = true;
            } else if (this.tickCount == 40) {
                this.updateList();
            } else if (this.tickCount > 40 && !this.targetList.isEmpty()) {
                if (this.tickCount == 80) {
                    this.updateList();
                }
                for (int i = 0; i < this.shotsPerTick; ++i) {
                    int num;
                    while (this.usedIndexes.contains(num = this.random.nextInt(this.list.size())) && this.usedIndexes.size() != this.list.size()) {
                    }
                    this.usedIndexes.add(num);
                    LaserDomeCoreEntity target = this;
                    int targetIndex = this.random.nextInt(this.targetList.size());
                    target = this.targetList.get(targetIndex);
                    if (target == null || !target.isAlive() || this.getCaster() == null) continue;
                    LaserDomeShotEntity bullet = this.list.get(num);
                    bullet.shoot(target.getX() - (bullet.getX() + this.level().random.nextDouble() - 0.5), target.getY() - bullet.getY(), target.getZ() - (bullet.getZ() + this.level().random.nextDouble() - 0.5), 2.0f, 0.0f);
                    this.level().playSound(this.getCaster(), this.getCaster().blockPosition(), (SoundEvent)ModSounds.laser.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
                }
            }
        }
        super.tick();
    }

    private void updateList() {
        if (this.level().isClientSide()) {
            return;
        }
        List tempList = this.level().getEntities((Entity)this.getCaster(), this.getBoundingBox().inflate((double)this.radius, (double)this.radius, (double)this.radius));
        Party casterParty = WorldData.get(this.level().getServer()).getPartyFromMember(this.getCaster().getUUID());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                tempList.remove(this.level().getPlayerByUUID(m.getUUID()));
            }
        } else {
            tempList.remove(this.getOwner());
        }
        this.targetList.clear();
        for (Entity t : tempList) {
            if (t instanceof LaserDomeShotEntity || t instanceof ItemDropEntity || t instanceof ItemEntity || t instanceof ExperienceOrb) continue;
            this.targetList.add(t);
        }
    }

    protected void onHit(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
            compound.putString("TargetUUID", ((UUID)((Optional)this.entityData.get(TARGET)).get()).toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
        this.entityData.set(TARGET, Optional.of(UUID.fromString(compound.getString("TargetUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public Player getTarget() {
        return ((Optional)this.getEntityData().get(TARGET)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.entityData.set(TARGET, Optional.of(uuid));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(new UUID(0L, 0L)));
        pBuilder.define(TARGET, Optional.of(new UUID(0L, 0L)));
    }
}

