/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class LaserDomeShotEntity
extends ThrowableProjectile {
    int maxTicks = 220;
    float dmg;

    public LaserDomeShotEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public LaserDomeShotEntity(Level world, LivingEntity player, double dmg) {
        super(ModEntities.TYPE_LASER_SHOT.get(), player, world);
        this.dmg = (float)dmg;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (!this.level().isClientSide) {
            this.setSharedFlag(6, this.isCurrentlyGlowing());
        }
        this.baseTick();
        HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        boolean flag = false;
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)raytraceresult).getBlockPos();
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (blockstate.is(Blocks.NETHER_PORTAL) || blockstate.is(Blocks.END_GATEWAY)) {
                this.handlePortal();
                flag = true;
            }
        }
        if (raytraceresult.getType() != HitResult.Type.MISS && !flag && !((ProjectileImpactEvent)NeoForge.EVENT_BUS.post((Event)new ProjectileImpactEvent((Projectile)this, raytraceresult))).isCanceled()) {
            this.onHit(raytraceresult);
        }
        this.checkInsideBlocks();
        Vec3 vector3d = this.getDeltaMovement();
        double d2 = this.getX() + vector3d.x;
        double d0 = this.getY() + vector3d.y;
        double d1 = this.getZ() + vector3d.z;
        this.updateRotation();
        if (!this.isNoGravity()) {
            Vec3 vector3d1 = this.getDeltaMovement();
            this.setDeltaMovement(vector3d1.x, vector3d1.y - this.getGravity(), vector3d1.z);
        }
        this.setPos(d2, d0, d1);
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            LivingEntity target;
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && (entity = ertResult.getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner()) {
                target.hurt(target.damageSources().thrown((Entity)this, this.getOwner()), this.dmg);
                this.remove(Entity.RemovalReason.KILLED);
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }
}

