/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOrgPortalTPPacket;

public class OrgPortalEntity
extends Entity
implements IEntityWithComplexSpawn {
    int maxTicks = 100;
    float radius = 0.5f;
    BlockPos destinationPos;
    ResourceKey<Level> destinationDim;
    boolean shouldTeleport;

    public OrgPortalEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public OrgPortalEntity(Level world, BlockPos spawnPos, BlockPos destinationPos, ResourceKey<Level> destinationDim, boolean shouldTP) {
        super(ModEntities.TYPE_ORG_PORTAL.get(), world);
        this.setPos((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
        this.destinationPos = destinationPos;
        this.destinationDim = destinationDim;
        this.shouldTeleport = shouldTP;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX() - 1.0 + this.random.nextDouble() * 2.0, this.getY() + this.random.nextDouble() * 4.0, this.getZ() - 1.0 + this.random.nextDouble() * 2.0, 0.0, 0.0, 0.0);
        List tempList = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)this.radius, (double)this.radius, (double)this.radius));
        for (Entity t : tempList) {
            if (!this.shouldTeleport || t instanceof OrgPortalEntity) continue;
            if (!this.isAlive()) {
                return;
            }
            if (t == null || this.destinationPos == null || this.destinationPos.getX() == 0 || this.destinationPos.getY() == 0 || this.destinationPos.getZ() == 0) continue;
            double yOffset = t.getY() - this.getY();
            t.setPos((double)this.destinationPos.getX() + 0.5, (double)(this.destinationPos.getY() + 1) + yOffset, (double)this.destinationPos.getZ() + 0.5);
            if (!(t instanceof Player) || !this.level().isClientSide) continue;
            PacketHandler.sendToServer(new CSOrgPortalTPPacket(this.destinationDim, new Vec3((double)this.destinationPos.getX() + 0.5, (double)(this.destinationPos.getY() + 1) + yOffset, (double)this.destinationPos.getZ() + 0.5)));
        }
        super.tick();
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        if (this.destinationPos == null) {
            return;
        }
        buffer.writeBlockPos(new BlockPos(this.destinationPos.getX(), this.destinationPos.getY(), this.destinationPos.getZ()));
        buffer.writeResourceLocation(this.destinationDim.location());
        buffer.writeBoolean(this.shouldTeleport);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.destinationPos = additionalData.readBlockPos();
        this.destinationDim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)additionalData.readResourceLocation());
        this.shouldTeleport = additionalData.readBoolean();
    }
}

