/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import org.joml.Vector3f;

public class SaixShockwave
extends ThrowableProjectile {
    int maxTicks = 30;
    float dmg;

    public SaixShockwave(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public SaixShockwave(Level world, LivingEntity player, float damage) {
        super(ModEntities.TYPE_SAIX_SHOCKWAVE.get(), player, world);
        this.dmg = damage;
    }

    protected double getDefaultGravity() {
        return 0.25;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount > 2) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SQUID_INK, this.getX(), this.getY() + 0.15, this.getZ(), 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 8.0f), this.getX(), this.getY() + 0.25, this.getZ(), 1.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.0f, 0.8f), 6.0f), this.getX(), this.getY() + 0.6, this.getZ(), 1.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.0f, 0.8f), 6.0f), this.getX(), this.getY() + 0.9, this.getZ(), 1.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.0f, 0.8f), 6.0f), this.getX(), this.getY() + 1.15, this.getZ(), 1.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.0f, 0.8f), 6.0f), this.getX(), this.getY() + 1.6, this.getZ(), 1.0, 0.0, 0.0);
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            LivingEntity target;
            Entity entity;
            EntityHitResult ertResult;
            if (rtRes instanceof EntityHitResult && (ertResult = (EntityHitResult)rtRes) != null && (entity = ertResult.getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner()) {
                target.hurt(target.damageSources().thrown((Entity)this, this.getOwner()), this.dmg);
            }
            if (rtRes instanceof BlockHitResult) {
                BlockHitResult brtResult = (BlockHitResult)rtRes;
                this.setPos(this.getX(), this.getY() + 0.1, this.getZ());
                Vec3 mot = this.getDeltaMovement();
                double x = mot.x();
                double y = mot.y();
                double z = mot.z();
                this.setDeltaMovement(x, y * 0.0, z);
            }
        }
    }
}

