/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.magic.ThunderBoltEntity;

public class ThunderTrailCoreEntity
extends ThrowableProjectile {
    int maxTicks = 240;
    float dmg;
    BlockPos ogPos;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(ThunderTrailCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> TARGET = SynchedEntityData.defineId(ThunderTrailCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<BlockPos> OGPOS = SynchedEntityData.defineId(ThunderTrailCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public ThunderTrailCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public ThunderTrailCoreEntity(Level world, Player player, LivingEntity target, float dmg) {
        super(ModEntities.TYPE_THUNDER_TRAIL.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        this.setTarget(target.getUUID());
        this.dmg = dmg;
        this.setOgPos(player.blockPosition());
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.getOgPos() == null) {
            return;
        }
        if (this.tickCount > this.maxTicks || this.getCaster() == null || this.distanceToSqr(this.getOgPos().getX(), this.getOgPos().getY(), this.getOgPos().getZ()) > 900.0) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.getCaster() != null && this.tickCount % 3 == 0) {
            ThunderBoltEntity shot = new ThunderBoltEntity(this.getCaster().level(), this.getCaster(), this.getX(), this.getY() - 1.0, this.getZ(), this.dmg);
            shot.setCaster(this.getCaster().getUUID());
            this.level().addFreshEntity((Entity)shot);
            LightningBolt lightningBoltEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
            lightningBoltEntity.setVisualOnly(true);
            lightningBoltEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)this.blockPosition().below()));
            lightningBoltEntity.setCause(this.getCaster() instanceof ServerPlayer ? (ServerPlayer)this.getCaster() : null);
            this.level().addFreshEntity((Entity)lightningBoltEntity);
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
            compound.putString("TargetUUID", ((UUID)((Optional)this.entityData.get(TARGET)).get()).toString());
            int[] intArray = new int[]{((BlockPos)this.entityData.get(OGPOS)).getX(), ((BlockPos)this.entityData.get(OGPOS)).getY(), ((BlockPos)this.entityData.get(OGPOS)).getZ()};
            compound.putIntArray("OgPos", intArray);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
        this.entityData.set(TARGET, Optional.of(UUID.fromString(compound.getString("TargetUUID"))));
        int[] coords = compound.getIntArray("OgPos");
        BlockPos blockpos = new BlockPos(coords[0], coords[1], coords[2]);
        this.entityData.set(OGPOS, (Object)blockpos);
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public BlockPos getOgPos() {
        return (BlockPos)this.getEntityData().get(OGPOS);
    }

    public void setOgPos(BlockPos blockpos) {
        this.entityData.set(OGPOS, (Object)blockpos);
    }

    public Player getTarget() {
        return ((Optional)this.getEntityData().get(TARGET)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.entityData.set(TARGET, Optional.of(uuid));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(new UUID(0L, 0L)));
        pBuilder.define(TARGET, Optional.of(new UUID(0L, 0L)));
        pBuilder.define(OGPOS, (Object)new BlockPos(0, 0, 0));
    }
}

