/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.shotlock;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.data.PlayerData;

public class BaseShotlockShotEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    public float dmg;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(BaseShotlockShotEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.defineId(BaseShotlockShotEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(BaseShotlockShotEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BaseShotlockShotEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public BaseShotlockShotEntity(EntityType<? extends ThrowableProjectile> type, Level world, LivingEntity player, Entity target, double dmg) {
        super(type, player, world);
        this.dmg = (float)dmg;
        this.setTarget(target.getId());
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.tickCount > 20) {
            super.remove(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    protected void onHit(HitResult pResult) {
        Player owner;
        PlayerData playerData;
        Entity entity;
        if (!this.level().isClientSide && this.getOwner() != null && (entity = this.getOwner()) instanceof Player && (playerData = PlayerData.get(owner = (Player)entity)) != null && playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_hp_gain") > 0) {
            owner.heal((float)(playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_hp_gain") * 2));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
            compound.putInt("TargetUUID", ((Integer)this.entityData.get(TARGET)).intValue());
            compound.putInt("Color", ((Integer)this.entityData.get(COLOR)).intValue());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
        this.entityData.set(TARGET, (Object)compound.getInt("TargetUUID"));
        this.entityData.set(COLOR, (Object)compound.getInt("Color"));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public Entity getTarget() {
        return this.level().getEntity(((Integer)this.getEntityData().get(TARGET)).intValue());
    }

    public void setTarget(int i) {
        this.entityData.set(TARGET, (Object)i);
    }

    public int getColor() {
        return (Integer)this.getEntityData().get(COLOR);
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(new UUID(0L, 0L)));
        pBuilder.define(TARGET, (Object)0);
        pBuilder.define(COLOR, (Object)0);
    }
}

