/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.shotlock;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.shotlock.RagnarokShotEntity;

public class RagnarokCoreEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    List<RagnarokShotEntity> list = new ArrayList<RagnarokShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    float dmg;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(RagnarokCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> TARGETS = SynchedEntityData.defineId(RagnarokCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public RagnarokCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public RagnarokCoreEntity(Level world, Player player, List<Entity> targets, float dmg) {
        super(ModEntities.TYPE_SHOTLOCK_CIRCULAR.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        Object targetIDS = "";
        for (Entity t : targets) {
            targetIDS = (String)targetIDS + "," + t.getId();
        }
        this.setTarget(((String)targetIDS).substring(1));
        this.targetList = targets;
        this.dmg = dmg;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks || this.getCaster() == null) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        double X = this.getX();
        double Y = this.getY() + 1.0;
        double Z = this.getZ();
        if (this.getCaster() != null && this.getTargets() != null) {
            if (this.tickCount == 1) {
                this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.laser.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                for (int i = 0; i < this.getTargets().size(); ++i) {
                    Entity target = this.getTargets().get(i);
                    if (target == null) continue;
                    RagnarokShotEntity bullet = new RagnarokShotEntity(this.level(), (LivingEntity)this.getCaster(), target, this.dmg);
                    bullet.setColor(16757273);
                    float r = 0.3f;
                    double offset_amount = -1.5;
                    double alpha = Math.toRadians(this.getCaster().getYRot());
                    double theta = Math.PI * 2 / (double)this.getTargets().size();
                    double x = X + offset_amount * Math.sin(alpha) + (double)r * ((Math.cos((double)i * theta) + Math.sin(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta))) * Math.cos(alpha) + -Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta)) * Math.sin(alpha));
                    double y = Y + (double)r * (Math.cos(alpha) * Math.sin((double)i * theta) * Math.cos(alpha) + Math.sin(alpha) * Math.sin((double)i * theta) * Math.sin(alpha));
                    double z = Z - offset_amount * Math.cos(alpha) + (double)r * (-Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta)) * Math.cos(alpha) + (Math.cos((double)i * theta) + Math.cos(alpha) * Math.cos(alpha) * (1.0 - Math.cos((double)i * theta))) * Math.sin(alpha));
                    bullet.setPos(x, y, z);
                    bullet.setMaxTicks(this.maxTicks + 20);
                    this.list.add(bullet);
                    this.level().addFreshEntity((Entity)bullet);
                }
            } else if (this.tickCount > 4 && this.tickCount < 10) {
                for (int i = 0; i < this.list.size(); ++i) {
                    RagnarokShotEntity bullet = this.list.get(i);
                    float posI = i + this.tickCount * 2;
                    float r = 0.3f * (float)this.tickCount;
                    double offset_amount = -2.0;
                    double alpha = Math.toRadians(this.getCaster().getYRot());
                    double theta = Math.PI * 2 / (double)this.getTargets().size();
                    double x = X + offset_amount * Math.sin(alpha) + (double)r * ((Math.cos((double)posI * theta) + Math.sin(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta))) * Math.cos(alpha) + -Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta)) * Math.sin(alpha));
                    double y = Y + (double)r * (Math.cos(alpha) * Math.sin((double)posI * theta) * Math.cos(alpha) + Math.sin(alpha) * Math.sin((double)posI * theta) * Math.sin(alpha));
                    double z = Z - offset_amount * Math.cos(alpha) + (double)r * (-Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta)) * Math.cos(alpha) + (Math.cos((double)posI * theta) + Math.cos(alpha) * Math.cos(alpha) * (1.0 - Math.cos((double)posI * theta))) * Math.sin(alpha));
                    bullet.setPos(x, y, z);
                }
            }
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
            compound.putString("TargetsUUID", (String)this.entityData.get(TARGETS));
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
        this.entityData.set(TARGETS, (Object)compound.getString("TargetUUID"));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public List<Entity> getTargets() {
        String[] ids;
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (String id : ids = ((String)this.getEntityData().get(TARGETS)).split(",")) {
            if (id.equals("")) continue;
            list.add(this.level().getEntity(Integer.parseInt(id)));
        }
        return list;
    }

    public void setTarget(String lists) {
        this.entityData.set(TARGETS, (Object)lists);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(new UUID(0L, 0L)));
        pBuilder.define(TARGETS, (Object)"");
    }
}

