/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.shotlock;

import java.awt.Color;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.shotlock.BaseShotlockShotEntity;
import org.joml.Vector3f;

public class RagnarokShotEntity
extends BaseShotlockShotEntity {
    public RagnarokShotEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public RagnarokShotEntity(Level world, LivingEntity player, Entity target, double dmg) {
        super(ModEntities.TYPE_RAGNAROK_SHOTLOCK_SHOT.get(), world, player, target, dmg);
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount > 1) {
            Color color = new Color(this.getColor());
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), 1.0f), this.getX(), this.getY(), this.getZ(), 1.0, 1.0, 1.0);
        }
        if (this.tickCount % 10 == 0 && this.tickCount - 10 >= 6) {
            this.updateMovement();
        }
        super.tick();
    }

    private void updateMovement() {
        if (this.getTarget() != null) {
            if (this.getTarget().isAlive()) {
                this.shoot(this.getTarget().getX() - this.getX(), this.getTarget().getY() + (double)(this.getTarget().getBbHeight() / 2.0f) - (double)this.getBbHeight() - this.getY() + 0.5, this.getTarget().getZ() - this.getZ(), 1.0f, 0.0f);
            } else if (this.getOwner() != null) {
                this.shootFromRotation((Entity)this, this.getOwner().getXRot(), this.getOwner().getYRot(), 0.0f, 1.0f, 0.0f);
            }
        }
    }

    @Override
    protected void onHit(HitResult rtRes) {
        LivingEntity target;
        EntityHitResult ertResult;
        Entity entity;
        super.onHit(rtRes);
        if (!this.level().isClientSide && rtRes instanceof EntityHitResult && (entity = (ertResult = (EntityHitResult)rtRes).getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner()) {
            target.invulnerableTime = 0;
            target.hurt(target.damageSources().thrown((Entity)this, this.getOwner()), this.dmg);
            super.remove(Entity.RemovalReason.KILLED);
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    @Override
    public void remove(Entity.RemovalReason reason) {
        if (this.tickCount > 40) {
            super.remove(Entity.RemovalReason.KILLED);
        }
    }
}

