/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.shotlock;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.shotlock.VolleyShotEntity;
import org.joml.Vector3f;

public class SonicBladeCoreEntity
extends ThrowableProjectile {
    int maxTicks = 260;
    List<VolleyShotEntity> list = new ArrayList<VolleyShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    float dmg;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(SonicBladeCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> TARGETS = SynchedEntityData.defineId(SonicBladeCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> ACTUAL_TARGET_INDEX = SynchedEntityData.defineId(SonicBladeCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SonicBladeCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public SonicBladeCoreEntity(Level world, Player player, List<Entity> targets, float dmg) {
        super(ModEntities.TYPE_SHOTLOCK_SONIC_BLADE.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        Object targetIDS = "";
        for (Entity t : targets) {
            targetIDS = (String)targetIDS + "," + t.getId();
        }
        this.setTarget(((String)targetIDS).substring(1));
        this.targetList = targets;
        this.dmg = dmg;
    }

    public void tick() {
        if (this.getCaster() == null) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        this.getCaster().startAutoSpinAttack(10, 4.0f, this.getCaster().getMainHandItem());
        if (this.tickCount % 8 == 1) {
            if (this.getCaster() != null && this.getTarget() != null) {
                BlockPos pos = this.getTarget().blockPosition();
                float speedFactor = 0.4f;
                this.getCaster().setDeltaMovement(((double)pos.getX() - this.getCaster().getX()) * (double)speedFactor, ((double)pos.getY() - this.getCaster().getY()) * (double)speedFactor, ((double)pos.getZ() - this.getCaster().getZ()) * (double)speedFactor);
                if (this.level().isClientSide) {
                    this.getCaster().hurtMarked = true;
                }
                if (this.getCaster().getVehicle() != null) {
                    this.getCaster().getVehicle().onPassengerTurned((Entity)this.getCaster());
                }
                this.setActualTargetIndex(this.getActualTargetIndex() + 1);
            } else {
                this.kill();
                return;
            }
        }
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount > 1 && this.getOwner() != null) {
            Color color = new Color(255, 255, 255);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), 1.0f), this.getOwner().getX(), this.getOwner().getY() + 1.0, this.getOwner().getZ(), 1.0, 1.0, 1.0);
        }
        if (this.tickCount % 4 == 0) {
            double r = 1.5;
            AABB aabb = new AABB(this.getOwner().position().x, this.getOwner().position().y, this.getOwner().position().z, this.getOwner().position().x + 1.0, this.getOwner().position().y + 1.0, this.getOwner().position().z + 1.0).inflate(r, 0.0, r);
            List list = this.getOwner().level().getEntitiesOfClass(LivingEntity.class, aabb);
            list.remove(this.getOwner());
            for (LivingEntity enemy : list) {
                enemy.hurt(enemy.damageSources().thrown((Entity)this, this.getOwner()), this.dmg);
            }
        }
        super.tick();
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    private Entity getTarget() {
        if (this.getTargets().size() <= this.getActualTargetIndex()) {
            return null;
        }
        return this.getTargets().get(this.getActualTargetIndex());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
            compound.putString("TargetsUUID", (String)this.entityData.get(TARGETS));
            compound.putInt("ActualTargetIndex", ((Integer)this.entityData.get(ACTUAL_TARGET_INDEX)).intValue());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
        this.entityData.set(TARGETS, (Object)compound.getString("TargetUUID"));
        this.entityData.set(ACTUAL_TARGET_INDEX, (Object)compound.getInt("ActualTargetIndex"));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public int getActualTargetIndex() {
        return (Integer)this.getEntityData().get(ACTUAL_TARGET_INDEX);
    }

    public void setActualTargetIndex(int actual) {
        this.entityData.set(ACTUAL_TARGET_INDEX, (Object)actual);
    }

    public List<Entity> getTargets() {
        String[] ids;
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (String id : ids = ((String)this.getEntityData().get(TARGETS)).split(",")) {
            if (id.equals("")) continue;
            list.add(this.level().getEntity(Integer.parseInt(id)));
        }
        return list;
    }

    public void setTarget(String lists) {
        this.entityData.set(TARGETS, (Object)lists);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(new UUID(0L, 0L)));
        pBuilder.define(TARGETS, (Object)"");
        pBuilder.define(ACTUAL_TARGET_INDEX, (Object)0);
    }
}

