/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.shotlock;

import java.awt.Color;
import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.shotlock.BaseShotlockShotEntity;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.joml.Vector3f;

public class UltimaCannonShotEntity
extends BaseShotlockShotEntity {
    public UltimaCannonShotEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public UltimaCannonShotEntity(Level world, LivingEntity player, Entity target, double dmg) {
        super(ModEntities.TYPE_ULTIMA_CANNON_SHOT.get(), world, player, target, dmg * 15.0);
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount > 1) {
            Color color = new Color(this.getColor());
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), 1.0f), this.getX(), this.getY(), this.getZ(), 1.0, 1.0, 1.0);
        }
        if (this.tickCount > 30 && this.tickCount % 10 == 0) {
            this.updateMovement();
        }
        super.tick();
    }

    private void updateMovement() {
        if (this.getTarget() != null) {
            if (this.getTarget().isAlive()) {
                this.shoot(this.getTarget().getX() - this.getX(), this.getTarget().getY() + (double)(this.getTarget().getBbHeight() / 2.0f) - (double)this.getBbHeight() - this.getY() + 0.5, this.getTarget().getZ() - this.getZ(), 1.0f, 0.0f);
            } else if (this.getOwner() != null) {
                this.shootFromRotation((Entity)this, this.getOwner().getXRot(), this.getOwner().getYRot(), 0.0f, 1.0f, 0.0f);
            }
        }
    }

    @Override
    protected void onHit(HitResult rtRes) {
        super.onHit(rtRes);
        if (!this.level().isClientSide && this.getOwner() != null) {
            LivingEntity target;
            EntityHitResult ertResult;
            Entity entity;
            if (rtRes instanceof EntityHitResult && (entity = (ertResult = (EntityHitResult)rtRes).getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner()) {
                target.hurt(target.damageSources().thrown((Entity)this, this.getOwner()), this.dmg);
            }
            for (int i = 0; i < 6; ++i) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY(), this.getZ(), 500, Math.random() * 5.0 - 2.5, Math.random() * 5.0 - 2.5, Math.random() * 5.0 - 2.5, 0.1);
            }
            List<Entity> list = this.level().getEntities(this.getOwner(), this.getBoundingBox().inflate(8.0));
            list = Utils.removePartyMembersFromList((Player)this.getOwner(), list);
            if (!list.isEmpty()) {
                for (Entity e : list) {
                    if (!(e instanceof LivingEntity)) continue;
                    e.hurt(e.damageSources().thrown((Entity)this, this.getOwner()), this.dmg / e.distanceTo((Entity)this) > 5.0f ? e.distanceTo((Entity)this) : 1.0f);
                }
            }
        }
        this.level().explode(this.getOwner(), (double)this.blockPosition().getX(), (double)this.blockPosition().getY(), (double)this.blockPosition().getZ(), 5.0f, false, Level.ExplosionInteraction.NONE);
        this.remove(Entity.RemovalReason.KILLED);
    }
}

