/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.DimensionCommand;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.damagesource.StopDamageSource;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.DriveFormDataLoader;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.SpawningMode;
import online.kingdomkeys.kingdomkeys.entity.block.SoRCoreTileEntity;
import online.kingdomkeys.kingdomkeys.entity.drops.DriveOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.drops.FocusOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.drops.HPOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.drops.HeartEntity;
import online.kingdomkeys.kingdomkeys.entity.drops.MPOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.drops.MunnyEntity;
import online.kingdomkeys.kingdomkeys.entity.drops.XPEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.DuskEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.entity.mob.MarluxiaEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.MoogleEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.ShadowEntity;
import online.kingdomkeys.kingdomkeys.entity.organization.KKThrowableEntity;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import online.kingdomkeys.kingdomkeys.item.KeybladeArmorItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.SynthesisItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataLoader;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.limit.LimitDataLoader;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.MagicDataLoader;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.menu.PauldronInventory;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetAirStepPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenAlignmentScreen;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncDriveFormData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncJsonRegistry;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncKeybladeData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncLimitData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncMagicData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncMoogleNames;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncOrganizationData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncShopData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncSynthesisData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldData;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateCORooms;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionHandler;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModJsonRegistries;

public class EntityEvents {
    public static boolean isBoss = false;
    public static boolean isHostiles = false;
    public int ticks;
    Map<UUID, Boolean> openedAlignment = new HashMap<UUID, Boolean>();
    int airstepTicks = -1;

    @SubscribeEvent
    public void soundPlayed(PlayLevelSoundEvent.AtEntity event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((SoundEvent)event.getSound().value()).getLocation().getPath().contains("step")) {
                boolean kbArmor = false;
                int index = 0;
                for (ItemStack a : player.getArmorSlots()) {
                    Item item = a.getItem();
                    if (item instanceof ArmorItem) {
                        ArmorItem armor = (ArmorItem)item;
                        if (index < 3 && ((ArmorMaterial)armor.getMaterial().value()).equipSound().value() == ModSounds.keyblade_armor.get()) {
                            kbArmor = true;
                        }
                    }
                    index = (byte)(index + 1);
                }
                if (kbArmor) {
                    event.getEntity().playSound((SoundEvent)ModSounds.keyblade_armor.get());
                }
            }
        }
    }

    @SubscribeEvent
    public void onXPPickup(PlayerXpEvent.XpChange e) {
        Player player;
        Player player2 = e.getEntity();
        if (player2 instanceof Player && (player = player2).getHealth() <= player.getMaxHealth() / 2.0f) {
            PlayerData playerData = PlayerData.get(player);
            e.setAmount(e.getAmount() * (playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost") + 1));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof LivingEntity) {
            IKHMob ikhmob;
            LivingEntity mob = (LivingEntity)entity;
            GlobalData mobData = GlobalData.get(mob);
            if (mobData == null) {
                return;
            }
            Player player = Utils.getClosestPlayer((Entity)mob, mob.level());
            if (player == null) {
                return;
            }
            if (e.getLevel().dimension().location().getPath().equals("realm_of_darkness") && mob instanceof IKHMob && (ikhmob = (IKHMob)mob).getKHMobType() == EntityHelper.MobType.HEARTLESS_PUREBLOOD) {
                double dist = e.getEntity().position().distanceTo(new Vec3(0.0, 62.0, 0.0));
                int level = (int)Math.min(dist / (double)ModConfigs.rodHeartlessLevelScale, (double)ModConfigs.rodHeartlessMaxLevel);
                mobData.setLevel(level);
            }
            if (mobData.getLevel() <= 0 && mob instanceof Monster && ((Boolean)ModConfigs.SERVER.hostileMobsLevel.get()).booleanValue()) {
                mobData.setLevel(Utils.getRandomMobLevel(player));
            }
            if (mob instanceof OwnableEntity) {
                LivingEntity livingEntity;
                OwnableEntity ownableEntity = (OwnableEntity)mob;
                if (mobData.getLevel() == 0 && (livingEntity = ownableEntity.getOwner()) instanceof Player) {
                    Player owner = (Player)livingEntity;
                    PlayerData ownerData = PlayerData.get(owner);
                    mobData.setLevel(ownerData.getLevel());
                }
            }
            if (mobData.getLevel() > 0) {
                int lvl = mobData.getLevel();
                Utils.applyMobLevel(mob, lvl);
                mob.heal(mob.getMaxHealth());
                if (!mob.hasCustomName() && !(mob instanceof OwnableEntity)) {
                    if (ModConfigs.mobLevelName) {
                        mob.setCustomName((Component)Component.translatable((String)(mob.getDisplayName().getString() + " Lv." + String.valueOf(Utils.getLevelColor(player, lvl)) + lvl + String.valueOf(ChatFormatting.RESET))));
                    }
                    PacketHandler.sendTo(new SCSyncGlobalData(mob), (ServerPlayer)player);
                }
            }
        }
    }

    public void checkRecipeMaterials(Player player) {
        RecipeRegistry.getInstance().getValues().forEach(recipe -> recipe.getMaterials().keySet().forEach(item -> {
            if (!item.builtInRegistryHolder().is(Tags.MATERIALS)) {
                player.sendSystemMessage((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "Recipe[" + recipe.getRegistryName().toString() + "] contains material(s) that are not present in the \"synthesis/materials\" tag you will be unable to create this recipe")));
            }
        }));
        BuiltInRegistries.ITEM.entrySet().stream().filter(itemRegistryObject -> itemRegistryObject.getValue() instanceof KeybladeItem).map(itemRegistryObject -> (KeybladeItem)itemRegistryObject.getValue()).toList().forEach(keybladeItem -> {
            if (keybladeItem.data != null) {
                for (int i = 0; i < keybladeItem.data.getMaxLevel(); ++i) {
                    keybladeItem.data.getLevelData(i).getMaterialList().keySet().forEach(item -> {
                        if (!item.builtInRegistryHolder().is(Tags.MATERIALS)) {
                            player.sendSystemMessage((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "Keyblade level data[" + String.valueOf(BuiltInRegistries.ITEM.getKey(keybladeItem)) + "] contains material(s) that are not present in the \"synthesis/materials\" tag you will be unable to upgrade this keyblade")));
                        }
                    });
                }
            }
        });
    }

    @SubscribeEvent
    public void animalTame(AnimalTameEvent event) {
        GlobalData mobData = GlobalData.get((LivingEntity)event.getAnimal());
        PlayerData ownerData = PlayerData.get(event.getTamer());
        mobData.setLevel(ownerData.getLevel());
        int lvl = mobData.getLevel();
        Utils.applyMobLevel((LivingEntity)event.getAnimal(), lvl);
        event.getAnimal().heal(event.getAnimal().getMaxHealth());
    }

    @SubscribeEvent
    public void dataPackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            PacketHandler.sendTo(new SCSyncKeybladeData(KeybladeDataLoader.names, KeybladeDataLoader.dataList), player);
            PacketHandler.sendTo(new SCSyncOrganizationData(OrganizationDataLoader.names, OrganizationDataLoader.dataList), player);
            PacketHandler.sendTo(new SCSyncSynthesisData(RecipeRegistry.getInstance().getValues()), player);
            PacketHandler.sendTo(new SCSyncMoogleNames(NamesListRegistry.getInstance()), player);
            PacketHandler.sendTo(new SCSyncShopData(ShopListRegistry.getInstance().getValues()), player);
            PacketHandler.sendTo(new SCSyncMagicData(MagicDataLoader.names, MagicDataLoader.dataList), player);
            PacketHandler.sendTo(new SCSyncDriveFormData(DriveFormDataLoader.names, DriveFormDataLoader.dataList), player);
            PacketHandler.sendTo(new SCSyncLimitData(LimitDataLoader.names, LimitDataLoader.dataList), player);
            ModJsonRegistries.registry.forEach(jsonRegistry -> PacketHandler.sendTo(new SCSyncJsonRegistry(jsonRegistry), player));
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        this.checkRecipeMaterials(e.getEntity());
        Player player = e.getEntity();
        PlayerData playerData = PlayerData.get(player);
        WorldData worldData = WorldData.get(e.getEntity().getServer());
        GlobalData.clearClientCache();
        CastleOblivionData.InteriorData.clearClientCache();
        if (playerData != null) {
            if (worldData != null) {
                if (worldData.getHeartlessSpawnLevel() > 0 && ModConfigs.heartlessSpawningMode == SpawningMode.NEVER) {
                    worldData.setHeartlessSpawnLevel(0);
                } else if (worldData.getHeartlessSpawnLevel() == 0 && ModConfigs.heartlessSpawningMode == SpawningMode.ALWAYS) {
                    worldData.setHeartlessSpawnLevel(1);
                }
            }
            if (!player.level().isClientSide) {
                int i;
                HashMap accessoriesMap;
                int i2;
                HashMap<Integer, Object> map;
                if (!playerData.getDriveFormMap().containsKey(DriveForm.NONE.toString())) {
                    playerData.setDriveFormLevel(DriveForm.NONE.toString(), 1);
                    playerData.setDriveFormLevel(DriveForm.SYNCH_BLADE.toString(), 1);
                    playerData.setDriveFormLevel("kingdomkeys:form_anti", 1);
                    if (playerData.getEquippedItems().isEmpty()) {
                        map = new HashMap<Integer, ItemStack>();
                        for (i2 = 0; i2 < 4; ++i2) {
                            map.put(i2, ItemStack.EMPTY);
                        }
                        playerData.equipAllItems(map, true);
                    }
                }
                ModConfigs.startingRecipes.forEach(resourceLocation -> {
                    if (RecipeRegistry.getInstance().containsKey((ResourceLocation)resourceLocation)) {
                        playerData.addKnownRecipe((ResourceLocation)resourceLocation);
                    } else {
                        KingdomKeys.LOGGER.error("Recipe[{}] in startingRecipes config doesn't exist", resourceLocation);
                    }
                });
                if (!playerData.getDriveFormMap().containsKey("kingdomkeys:form_anti")) {
                    playerData.setDriveFormLevel("kingdomkeys:form_anti", 1);
                }
                if (!playerData.getDriveFormMap().containsKey("kingdomkeys:form_anti")) {
                    playerData.setDriveFormLevel("kingdomkeys:form_anti", 1);
                }
                if (playerData.getSoAState() == SoAState.COMPLETE) {
                    switch (playerData.getChosen()) {
                        case WARRIOR: {
                            if (playerData.getStrengthStat().hasModifier("choice") || playerData.getStrengthStat().hasModifier("sacrifice")) break;
                            playerData.setStrength(playerData.getStrength(false) - 1);
                            playerData.getStrengthStat().addModifier("choice", 1.0, false, false);
                            break;
                        }
                        case GUARDIAN: {
                            if (playerData.getDefenseStat().hasModifier("choice") || playerData.getDefenseStat().hasModifier("sacrifice")) break;
                            playerData.setDefense(playerData.getDefense(false) - 1);
                            playerData.getDefenseStat().addModifier("choice", 1.0, false, false);
                            break;
                        }
                        case MYSTIC: {
                            if (playerData.getMagicStat().hasModifier("choice") || playerData.getMagicStat().hasModifier("sacrifice")) break;
                            playerData.setMagic(playerData.getMagic(false) - 1);
                            playerData.getMagicStat().addModifier("choice", 1.0, false, false);
                        }
                    }
                    switch (playerData.getSacrificed()) {
                        case WARRIOR: {
                            if (playerData.getStrengthStat().hasModifier("choice") || playerData.getStrengthStat().hasModifier("sacrifice")) break;
                            playerData.setStrength(playerData.getStrength(false) + 1);
                            playerData.getStrengthStat().addModifier("sacrifice", -1.0, false, false);
                            break;
                        }
                        case GUARDIAN: {
                            if (playerData.getDefenseStat().hasModifier("choice") || playerData.getDefenseStat().hasModifier("sacrifice")) break;
                            playerData.setDefense(playerData.getDefense(false) + 1);
                            playerData.getDefenseStat().addModifier("sacrifice", -1.0, false, false);
                            break;
                        }
                        case MYSTIC: {
                            if (playerData.getMagicStat().hasModifier("choice") || playerData.getMagicStat().hasModifier("sacrifice")) break;
                            playerData.setMagic(playerData.getMagic(false) + 1);
                            playerData.getMagicStat().addModifier("sacrifice", -1.0, false, false);
                        }
                    }
                }
                if (!playerData.getEquippedWeapon().is(Items.AIR)) {
                    Utils.createKeybladeID(playerData.getEquippedWeapon());
                }
                playerData.getWeaponsUnlocked().forEach(itemStack -> {
                    if (itemStack.is(playerData.getEquippedWeapon().getItem())) {
                        Utils.copyKeybladeID(playerData.getEquippedWeapon(), itemStack);
                    } else {
                        Utils.createKeybladeID(itemStack);
                    }
                });
                if (!playerData.getDriveFormMap().containsKey(DriveForm.SYNCH_BLADE.toString())) {
                    playerData.setDriveFormLevel(DriveForm.SYNCH_BLADE.toString(), 1);
                }
                if (playerData.getEquippedKBArmors().isEmpty()) {
                    map = new HashMap();
                    for (i2 = 0; i2 < 1; ++i2) {
                        map.put(i2, ItemStack.EMPTY);
                    }
                    playerData.equipAllKBArmor(map, true);
                }
                if ((accessoriesMap = (HashMap)playerData.getEquippedAccessories()).isEmpty()) {
                    for (i2 = 0; i2 < 4; ++i2) {
                        accessoriesMap.put(i2, ItemStack.EMPTY);
                    }
                }
                for (i2 = accessoriesMap.size(); i2 < 4; ++i2) {
                    accessoriesMap.put(i2, ItemStack.EMPTY);
                }
                playerData.equipAllAccessories(accessoriesMap, true);
                HashMap armorsMap = (HashMap)playerData.getEquippedArmors();
                if (armorsMap.isEmpty()) {
                    for (i = 0; i < 4; ++i) {
                        armorsMap.put(i, ItemStack.EMPTY);
                    }
                }
                for (i = armorsMap.size(); i < 4; ++i) {
                    armorsMap.put(i, ItemStack.EMPTY);
                }
                playerData.equipAllArmors(armorsMap, true);
                playerData.getDriveFormMap().keySet().forEach(key -> {
                    if (ModDriveForms.registry.containsKey(ResourceLocation.parse((String)key)) && ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)key))).hasKeychain() && playerData.getDriveFormMap().containsKey(key) && !playerData.getEquippedKeychains().containsKey(ResourceLocation.parse((String)key))) {
                        playerData.setNewKeychain(ResourceLocation.parse((String)key), ItemStack.EMPTY);
                    }
                });
                PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                PacketHandler.sendTo(new SCSyncWorldData(player.getServer()), (ServerPlayer)player);
                PacketHandler.syncToAllAround(player, playerData);
                Utils.RefreshAbilityAttributes(player, playerData);
                if (player.level().dimension().location().getPath().contains("castle_oblivion_interior")) {
                    SCSyncCastleOblivionInteriorData.syncClients((ServerLevel)player.level());
                    PacketHandler.sendTo(new SCUpdateCORooms(CastleOblivionHandler.getCurrentFloor(player).getRooms()), (ServerPlayer)player);
                } else {
                    PacketHandler.sendTo(new SCUpdateCORooms(List.of()), (ServerPlayer)player);
                }
            }
            PacketHandler.syncToAllAround(player, playerData);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Pre event) {
        PlayerData playerData;
        Player player = event.getEntity();
        if (this.ticks >= Integer.MAX_VALUE) {
            this.ticks = Integer.MIN_VALUE;
        }
        if ((playerData = PlayerData.get(player)) != null) {
            ArrayList<ReactionCommand> rcList = new ArrayList<ReactionCommand>();
            for (ReactionCommand rc : ModReactionCommands.registry) {
                if (!rc.needsConstantCheck() || !rc.conditionsToAppear(player, (LivingEntity)player)) continue;
                rcList.add(rc);
            }
            for (String rcName : playerData.getReactionCommands()) {
                ReactionCommand rc = (ReactionCommand)ModReactionCommands.registry.get(ResourceLocation.parse((String)rcName));
                if (!rc.conditionsToAppear(player, (LivingEntity)player)) continue;
                rcList.add(rc);
            }
            playerData.setReactionCommands(new ArrayList<String>());
            for (ReactionCommand rc : rcList) {
                playerData.addReactionCommand(rc.getName(), player);
            }
            if (!player.level().isClientSide && player.tickCount == 5) {
                PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            }
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                if (playerData.getFP() > 0.0) {
                    playerData.setFP(playerData.getFP() - 0.3);
                } else {
                    playerData.setActiveDriveForm(DriveForm.NONE.toString());
                    player.level().playSound(player, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    if (!player.level().isClientSide) {
                        PacketHandler.syncToAllAround(player, playerData);
                    }
                }
            } else if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()))).updateDrive(player);
            }
            if (playerData.getLimitCooldownTicks() > 0 && !player.level().isClientSide) {
                playerData.setLimitCooldownTicks(playerData.getLimitCooldownTicks() - 1);
                if (playerData.getLimitCooldownTicks() <= 0) {
                    PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                }
            }
            if (playerData.getMagicCasttimeTicks() > 0 && !player.level().isClientSide) {
                playerData.remMagicCasttimeTicks(1);
            }
            if (playerData.getCastedMagic() != null && playerData.getMagicCasttimeTicks() <= 0) {
                Utils.castMagic castedMagic = playerData.getCastedMagic();
                castedMagic.magic().magicUse(castedMagic.player(), castedMagic.caster(), castedMagic.level(), castedMagic.fullMPBlastMult(), castedMagic.lockOnEntity());
                player.swing(InteractionHand.MAIN_HAND, true);
                playerData.setCastedMagic(null);
                PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            }
            if (playerData.getMagicCooldownTicks() > 0 && !player.level().isClientSide) {
                playerData.setMagicCooldownTicks(playerData.getMagicCooldownTicks() - 1);
                if (playerData.getMagicCooldownTicks() <= 0) {
                    PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                }
            }
            if (playerData.getRecharge()) {
                if (playerData.getMP() >= playerData.getMaxMP()) {
                    playerData.setRecharge(false);
                    playerData.setMP(playerData.getMaxMP());
                } else {
                    if (playerData.getMP() < 0.0) {
                        playerData.setMP(0.0);
                    }
                    playerData.addMP(playerData.getMaxMP() / 500.0 * (Utils.getMPHasteValue(playerData) / 10.0 + 2.0));
                }
            } else if (playerData.getMP() <= 0.0 && playerData.getMaxMP() > 0.0) {
                playerData.setRecharge(true);
                if (!player.level().isClientSide) {
                    PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                }
            }
            if (!player.level().isClientSide) {
                if (playerData.getAlignment() == Utils.OrgMember.NONE) {
                    boolean wearingOrgCloak;
                    if (!this.openedAlignment.containsKey(player.getUUID())) {
                        this.openedAlignment.put(player.getUUID(), false);
                    }
                    if (wearingOrgCloak = Utils.isWearingOrgRobes(player)) {
                        if (!this.openedAlignment.get(player.getUUID()).booleanValue()) {
                            PacketHandler.sendTo(new SCOpenAlignmentScreen(), (ServerPlayer)player);
                            this.openedAlignment.put(player.getUUID(), true);
                        }
                    } else {
                        this.openedAlignment.put(player.getUUID(), false);
                    }
                }
                if (playerData.isAbilityEquipped("kingdomkeys:ability_treasure_magnet") && !player.isCrouching() && player.getInventory().getFreeSlot() > -1) {
                    double x = player.getX();
                    double y = player.getY() + 0.75;
                    double z = player.getZ();
                    float range = 1 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_treasure_magnet");
                    List items = player.level().getEntitiesOfClass(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
                    int pulled = 0;
                    for (ItemEntity item : items) {
                        if (item.tickCount < 20 || pulled > 200) break;
                        Vec3 entityVector = new Vec3(item.getX(), item.getY() - (double)(item.getBbHeight() / 2.0f), item.getZ());
                        Vec3 finalVector = new Vec3(x, y, z).subtract(entityVector);
                        if (Math.sqrt(x * x + y * y + z * z) > 1.0) {
                            finalVector = finalVector.normalize();
                        }
                        item.setDeltaMovement(finalVector.multiply((double)0.45f, (double)0.45f, (double)0.45f));
                        ++pulled;
                    }
                }
            }
        }
        if (this.ticks % 5 == 0) {
            this.updateCommandMenu(player);
        }
    }

    private void updateCommandMenu(Player player) {
        List<LivingEntity> entities = Utils.getLivingEntitiesInRadius((Entity)player, 16.0f);
        List<LivingEntity> bossEntities = Utils.getLivingEntitiesInRadius((Entity)player, 150.0f);
        if (!bossEntities.isEmpty()) {
            for (int i = 0; i < bossEntities.size(); ++i) {
                if (bossEntities.get(i) instanceof EnderDragon || bossEntities.get(i) instanceof WitherBoss || bossEntities.get(i) instanceof MarluxiaEntity) {
                    isBoss = true;
                    return;
                }
                isBoss = false;
            }
        } else {
            isBoss = false;
        }
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                if (entity instanceof Monster || entity instanceof Slime) {
                    isHostiles = true;
                    return;
                }
                isHostiles = false;
            }
        } else {
            isHostiles = false;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity entity2 = (LivingEntity)entity;
            GlobalData globalData = GlobalData.get(entity2);
            PlayerData playerData = null;
            Entity entity3 = event.getEntity();
            if (entity3 instanceof Player && (playerData = PlayerData.get(player = (Player)entity3)) != null) {
                if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
                    if (player.onGround() && player.getBlockStateOn().getFriction((LevelReader)player.level(), player.blockPosition(), (Entity)player) <= 0.6f) {
                        player.setDeltaMovement(player.getDeltaMovement().multiply(new Vec3((double)form.getSpeedMult(), 1.0, (double)form.getSpeedMult())));
                    }
                }
                if (!playerData.getAirStep().equals((Object)new BlockPos(0, 0, 0))) {
                    ++this.airstepTicks;
                    BlockPos pos = playerData.getAirStep();
                    float speedFactor = 0.3f;
                    if (pos.distToCenterSqr((Position)player.position()) < 2.0 || this.airstepTicks > 5 && player.getDeltaMovement().x() == 0.0 && player.getDeltaMovement().z() == 0.0) {
                        player.setDeltaMovement(0.0, 0.0, 0.0);
                        player.setPos(pos.getCenter().subtract(0.0, 0.4, 0.0));
                        if (player.level().isClientSide) {
                            PacketHandler.sendToServer(new CSSetAirStepPacket(new BlockPos(0, 0, 0)));
                            this.airstepTicks = -1;
                        }
                    }
                    if (this.airstepTicks > -1) {
                        player.setDeltaMovement(((double)pos.getX() - player.getX()) * (double)speedFactor, ((double)pos.getY() - player.getY()) * (double)speedFactor, ((double)pos.getZ() - player.getZ()) * (double)speedFactor);
                    }
                }
            }
            if (globalData != null) {
                if (globalData.getStopModelTicks() > 0) {
                    globalData.setStopModelTicks(globalData.getStopModelTicks() - 1);
                    if (globalData.getStopModelTicks() <= 0) {
                        PacketHandler.syncToAllAround(entity2, globalData);
                    }
                }
                if (!(entity2.hasEffect(ModMobEffects.STOP) || globalData.getStopDamage().isEmpty() || globalData.getStopCaster() == null || entity2.hasEffect(ModMobEffects.KO) || entity2.tickCount % 4 != 0)) {
                    entity2.hurt(StopDamageSource.getStopDamage((Entity)Utils.getPlayerByName(entity2.level(), globalData.getStopCaster().toLowerCase())), globalData.getStopDamage().getFirst().floatValue() / 3.0f);
                    globalData.getStopDamage().removeFirst();
                    entity2.invulnerableTime = 4;
                    if (globalData.getStopDamage().isEmpty()) {
                        globalData.setStopCaster(null);
                    }
                }
            }
            if (entity2 instanceof Player) {
                player = (Player)entity2;
                if (playerData != null) {
                    if (playerData.getAerialDodgeTicks() > 0) {
                        playerData.setAerialDodgeTicks(playerData.getAerialDodgeTicks() - 1);
                    }
                    if (playerData.getReflectTicks() > 0) {
                        playerData.remReflectTicks(1);
                        entity2.setDeltaMovement(0.0, 0.0, 0.0);
                        entity2.hurtMarked = true;
                        float radius = 1.5f;
                        double X = entity2.getX();
                        double Y = entity2.getY();
                        double Z = entity2.getZ();
                        for (int t = 1; t < 360; t += 20) {
                            for (int s = 1; s < 360; s += 20) {
                                double x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                                double z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                                double y = Y + (double)radius * Math.cos(Math.toRadians(t));
                                entity2.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, x, y + 1.0, z, 0.0, 0.0, 0.0);
                            }
                        }
                    } else if (playerData.getReflectActive() && !player.level().isClientSide()) {
                        float dmgMult = 1.0f;
                        float radius = 1.0f;
                        dmgMult = switch (playerData.getReflectLevel()) {
                            case 0 -> {
                                radius = 2.5f;
                                yield 0.3f;
                            }
                            case 1 -> {
                                radius = 3.0f;
                                yield 0.5f;
                            }
                            case 2 -> {
                                radius = 3.5f;
                                yield 0.7f;
                            }
                            default -> dmgMult;
                        };
                        List list = player.level().getEntities((Entity)player, player.getBoundingBox().inflate((double)radius, (double)radius, (double)radius));
                        Party casterParty = WorldData.get(player.level().getServer()).getPartyFromMember(player.getUUID());
                        if (casterParty != null && !casterParty.getFriendlyFire()) {
                            for (Party.Member m : casterParty.getMembers()) {
                                list.remove(player.level().getPlayerByUUID(m.getUUID()));
                            }
                        }
                        double X = entity2.getX();
                        double Y = entity2.getY();
                        double Z = entity2.getZ();
                        for (int t = 1; t < 360; t += 20) {
                            double x = X + (double)radius * Math.cos(Math.toRadians(t));
                            double z = Z + (double)radius * Math.sin(Math.toRadians(t));
                            ((ServerLevel)entity2.level()).sendParticles((ParticleOptions)ParticleTypes.BUBBLE.getType(), x, Y + 1.0, z, 5, 0.0, 0.0, 0.0, 1.0);
                        }
                        if (!list.isEmpty()) {
                            for (Entity e : list) {
                                if (!(e instanceof LivingEntity)) continue;
                                e.hurt(e.damageSources().playerAttack(player), DamageCalculation.getMagicDamage(player) * dmgMult * ((Magic)ModMagic.registry.get(ResourceLocation.parse((String)"kingdomkeys:magic_reflect"))).getDamageMult(playerData.getReflectLevel()));
                            }
                            player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.reflect2.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        playerData.setReflectActive(false);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void entityPickup(ItemEntityPickupEvent.Pre event) {
        if (event.getItemEntity().getItem() != null && event.getItemEntity().getItem().getItem() instanceof SynthesisItem) {
            for (int i = 0; i < event.getPlayer().getInventory().getContainerSize(); ++i) {
                ItemStack bag = event.getPlayer().getInventory().getItem(i);
                if (ItemStack.matches((ItemStack)bag, (ItemStack)ItemStack.EMPTY) || bag.getItem() != ModItems.synthesisBag.get()) continue;
                IItemHandler inv = (IItemHandler)bag.getCapability(Capabilities.ItemHandler.ITEM, null);
                this.addSynthesisMaterialToBag(inv, (ItemEntityPickupEvent)event, bag);
            }
        }
    }

    public void addSynthesisMaterialToBag(IItemHandler inv, ItemEntityPickupEvent event, ItemStack bag) {
        int bagLevel = (Integer)bag.getOrDefault(ModComponents.SYNTH_BAG_LEVEL, (Object)0);
        int maxSlots = switch (bagLevel) {
            case 0 -> 18;
            case 1 -> 36;
            case 2 -> 54;
            case 3 -> 72;
            default -> 0;
        };
        for (int j = 0; j < maxSlots; ++j) {
            ItemStack bagItem = inv.getStackInSlot(j);
            ItemStack pickUp = event.getItemEntity().getItem();
            if (!ItemStack.matches((ItemStack)bagItem, (ItemStack)ItemStack.EMPTY)) {
                if (!bagItem.getItem().equals(pickUp.getItem()) || bagItem.getCount() >= 64 || bagItem.getCount() + pickUp.getCount() > 64) continue;
                ItemStack stack = new ItemStack((ItemLike)pickUp.copy().getItem(), pickUp.copy().getCount());
                inv.insertItem(j, stack, false);
                pickUp.setCount(0);
                return;
            }
            if (!ItemStack.matches((ItemStack)bagItem, (ItemStack)ItemStack.EMPTY)) continue;
            inv.insertItem(j, pickUp.copy(), false);
            pickUp.setCount(0);
            return;
        }
    }

    @SubscribeEvent
    public void hitEntity(LivingDamageEvent.Pre event) {
        Object playerData;
        LivingEntity weapon;
        Player player;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            PlayerData playerData2;
            player = (Player)entity;
            weapon = Utils.getWeaponDamageStack(event.getSource(), player);
            if (weapon != null && !(event.getSource() instanceof StopDamageSource)) {
                float dmg = 0.0f;
                if (weapon.getItem() instanceof KeybladeItem) {
                    dmg = DamageCalculation.getKBStrengthDamage(player, (ItemStack)weapon);
                } else if (weapon.getItem() instanceof IOrgWeapon) {
                    dmg = DamageCalculation.getOrgStrengthDamage(player, (ItemStack)weapon);
                }
                if (!(!(player.fallDistance > 0.0f) || player.onGround() || player.onClimbable() || player.isInWater() || player.hasEffect(MobEffects.BLINDNESS) || player.isPassenger())) {
                    dmg = (float)((double)dmg * ModConfigs.critMult);
                    dmg += dmg * (float)PlayerData.get(player).getNumberOfAbilitiesEquipped("kingdomkeys:ability_critical_boost") * 0.1f;
                }
                float newDMG = event.getNewDamage() - 1.0f + dmg * player.getAttackStrengthScale(0.0f);
                event.setNewDamage(newDMG);
            }
            if ((playerData2 = PlayerData.get(player)) != null && playerData2.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                event.setNewDamage((float)playerData2.getStrength(true));
            }
        }
        if ((weapon = event.getEntity()) instanceof Player) {
            player = (Player)weapon;
            playerData = PlayerData.get(player);
            if (playerData == null) {
                return;
            }
            if (((PlayerData)playerData).getReflectTicks() <= 0) {
                if (((PlayerData)playerData).isAbilityEquipped("kingdomkeys:ability_mp_rage")) {
                    ((PlayerData)playerData).addMP(event.getNewDamage() * 0.2f * (float)((PlayerData)playerData).getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_rage"));
                    PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                }
                if (((PlayerData)playerData).isAbilityEquipped("kingdomkeys:ability_damage_drive")) {
                    ((PlayerData)playerData).addDP(event.getNewDamage() * 0.2f * (float)((PlayerData)playerData).getNumberOfAbilitiesEquipped("kingdomkeys:ability_damage_drive"));
                    PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                }
            }
        }
        if ((playerData = event.getEntity()) instanceof Player) {
            float protectReduction;
            player = (Player)playerData;
            playerData = PlayerData.get(player);
            float damage = event.getNewDamage() * 100.0f / (float)(100 + ((PlayerData)playerData).getDefense(true));
            if (player.hasEffect(ModMobEffects.AERO)) {
                MobEffectInstance aero = player.getEffect(ModMobEffects.AERO);
                float resistMultiplier = aero.getAmplifier() == 0 ? 0.3f : (aero.getAmplifier() == 1 ? 0.35f : (aero.getAmplifier() == 2 ? 0.4f : 0.0f));
                damage -= damage * resistMultiplier;
            }
            if (event.getSource().getMsgId().equals(KKResistanceType.fire.toString())) {
                damage *= (float)(100 - Utils.getArmorsStat((PlayerData)playerData, KKResistanceType.fire.toString())) / 100.0f;
            } else if (event.getSource().getMsgId().equals(KKResistanceType.ice.toString())) {
                damage *= (float)(100 - Utils.getArmorsStat((PlayerData)playerData, KKResistanceType.ice.toString())) / 100.0f;
            } else if (event.getSource().getMsgId().equals(KKResistanceType.lightning.toString())) {
                damage *= (float)(100 - Utils.getArmorsStat((PlayerData)playerData, KKResistanceType.lightning.toString())) / 100.0f;
            } else if (event.getSource().getMsgId().equals(KKResistanceType.darkness.toString())) {
                damage *= (float)(100 - Utils.getArmorsStat((PlayerData)playerData, KKResistanceType.darkness.toString())) / 100.0f;
            }
            if (Utils.isPlayerLowHP(player) && ((PlayerData)playerData).isAbilityEquipped("kingdomkeys:ability_damage_control")) {
                damage /= (float)(1 + ((PlayerData)playerData).getNumberOfAbilitiesEquipped("kingdomkeys:ability_damage_control"));
            }
            if (((PlayerData)playerData).isAbilityEquipped("kingdomkeys:ability_protect")) {
                protectReduction = damage * 0.1f;
                damage -= protectReduction;
            }
            if (((PlayerData)playerData).isAbilityEquipped("kingdomkeys:ability_protectra")) {
                protectReduction = damage * 0.2f;
                damage -= protectReduction;
            }
            if (((PlayerData)playerData).isAbilityEquipped("kingdomkeys:ability_protectga")) {
                protectReduction = damage * 0.4f;
                damage -= protectReduction;
            }
            if (((PlayerData)playerData).isAbilityEquipped("kingdomkeys:ability_second_chance") && damage >= player.getHealth() && player.getHealth() > 1.0f) {
                if (player.hasEffect(MobEffects.REGENERATION)) {
                    player.removeEffect(MobEffects.REGENERATION);
                    player.effectsDirty = true;
                }
                damage = player.getHealth() - 1.0f;
            }
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            PacketHandler.sendTo(new SCSyncGlobalData((LivingEntity)player), (ServerPlayer)player);
            if (!player.isDamageSourceBlocked(event.getSource())) {
                event.setNewDamage(damage <= 0.0f ? 1.0f : damage);
            }
        }
        if (event.getEntity() instanceof BaseKHEntity) {
            LivingEntity livingEntity;
            float damage = event.getNewDamage();
            int defense = ((BaseKHEntity)event.getEntity()).getDefense();
            if (defense > 0) {
                damage = Math.round(damage * 100.0f / (float)(300 + defense));
            }
            if (event.getEntity().hasEffect(ModMobEffects.AERO)) {
                MobEffectInstance aero = event.getEntity().getEffect(ModMobEffects.AERO);
                float resistMultiplier = aero.getAmplifier() == 0 ? 0.3f : (aero.getAmplifier() == 1 ? 0.35f : (aero.getAmplifier() == 2 ? 0.4f : 0.0f));
                damage -= damage * resistMultiplier;
            }
            if ((livingEntity = event.getEntity()) instanceof MarluxiaEntity) {
                MarluxiaEntity mar = (MarluxiaEntity)livingEntity;
                if (mar.getState() != 3 && mar.marluxiaGoal.chasedTimes == 0 && mar.getHealth() - damage <= 0.0f) {
                    ++mar.marluxiaGoal.chasedTimes;
                    mar.setState(3);
                    event.setNewDamage(mar.getHealth() - 1.0f);
                    mar.setInvulnerable(true);
                    return;
                }
                if (mar.getState() == 1) {
                    damage = event.getNewDamage() * 0.1f;
                    if (event.getSource().is(KKDamageTypes.FIRE)) {
                        mar.marluxiaGoal.removeArmor(mar);
                    }
                } else if (mar.getState() == 2 && event.getSource().getEntity() == mar.getKillCredit()) {
                    mar.setState(0);
                    mar.setNoGravity(false);
                }
            }
            event.setNewDamage(damage < 1.0f ? 1.0f : damage);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingIncomingDamageEvent event) {
        if (!event.getEntity().level().isClientSide) {
            Entity koInstance;
            GlobalData globalData;
            Object worldData;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Party p;
                Player player = (Player)livingEntity;
                worldData = WorldData.get(player.getServer());
                globalData = GlobalData.get((LivingEntity)player);
                if (worldData != null && globalData != null && ((WorldData)((Object)worldData)).getPartyFromMember(player.getUUID()) != null && !player.level().isClientSide() && Utils.anyPartyMemberOnExcept(player, p = ((WorldData)((Object)worldData)).getPartyFromMember(player.getUUID()), (ServerLevel)player.level())) {
                    if (((Boolean)ModConfigs.SERVER.allowPartyKO.get()).booleanValue()) {
                        if (!player.hasEffect(ModMobEffects.KO) && player.getHealth() - event.getAmount() <= 0.0f) {
                            event.setCanceled(true);
                            player.removeAllEffects();
                            player.setHealth(player.getMaxHealth());
                            player.invulnerableTime = 40;
                            player.getFoodData().setFoodLevel(10);
                            player.getFoodData().setExhaustion(0.0f);
                            player.getFoodData().setSaturation(0.0f);
                            koInstance = new MobEffectInstance(ModMobEffects.KO, -1, 0, false, false, false);
                            player.addEffect((MobEffectInstance)koInstance);
                            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.playerDeathHardcore.get(), SoundSource.PLAYERS);
                        }
                        PacketHandler.syncToAllAround((LivingEntity)player, globalData);
                    } else {
                        player.removeEffect(ModMobEffects.KO);
                    }
                }
            }
            if ((worldData = event.getSource().getEntity()) instanceof LivingEntity) {
                PlayerData playerData;
                Party p;
                LivingEntity attacker = (LivingEntity)worldData;
                LivingEntity target = event.getEntity();
                if (attacker instanceof Player && target instanceof Player && (p = WorldData.get(attacker.getServer()).getPartyFromMember(attacker.getUUID())) != null && p.getMember(event.getEntity().getUUID()) != null && !p.getFriendlyFire()) {
                    event.setCanceled(true);
                }
                if (target instanceof Player && (playerData = PlayerData.get((Player)target)) != null && playerData.getReflectTicks() > 0) {
                    if (!playerData.getReflectActive()) {
                        playerData.setReflectActive(true);
                    }
                    event.setCanceled(true);
                }
                if ((globalData = GlobalData.get(target)) != null && (koInstance = event.getSource().getEntity()) instanceof Player) {
                    Player source = (Player)koInstance;
                    if (target.hasEffect(ModMobEffects.STOP) && target.getEffect(ModMobEffects.STOP).getDuration() > 0) {
                        float dmg = event.getAmount();
                        if (event.getSource().getEntity() instanceof Player) {
                            ItemStack stack = Utils.getWeaponDamageStack(event.getSource(), source);
                            if (stack != null) {
                                if (stack.getItem() instanceof KeybladeItem) {
                                    dmg = DamageCalculation.getKBStrengthDamage((Player)event.getSource().getEntity(), stack);
                                } else if (stack.getItem() instanceof IOrgWeapon) {
                                    dmg = DamageCalculation.getOrgStrengthDamage((Player)event.getSource().getEntity(), stack);
                                }
                            }
                            if (dmg == 0.0f) {
                                dmg = event.getAmount();
                            }
                        }
                        globalData.addDamage(dmg);
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.getEntity().level().isClientSide) {
            Entity entity22;
            Player player;
            Object object;
            WorldData worldData = WorldData.get(event.getEntity().getServer());
            if (event.getEntity() instanceof EnderDragon) {
                LivingEntity entity3 = event.getEntity();
                if (worldData.getHeartlessSpawnLevel() == 0 && ModConfigs.heartlessSpawningMode == SpawningMode.AFTER_DRAGON) {
                    worldData.setHeartlessSpawnLevel(1);
                }
                object = entity3.level().players().iterator();
                while (object.hasNext()) {
                    Player p = (Player)object.next();
                    entity3.level().addFreshEntity((Entity)new ItemEntity(entity3.level(), p.getX(), p.getY(), p.getZ(), new ItemStack((ItemLike)ModItems.proofOfHeart.get(), 1)));
                }
            }
            if ((object = event.getEntity()) instanceof Player) {
                player = (Player)object;
                if (player.level().getLevelData().isHardcore()) {
                    player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.playerDeathHardcore.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.playerDeath.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            player = null;
            Entity entity4 = event.getSource().getDirectEntity();
            if (entity4 instanceof Player) {
                Player pl;
                player = pl = (Player)entity4;
            } else {
                entity4 = event.getSource().getEntity();
                if (entity4 instanceof Player) {
                    Player pl;
                    player = pl = (Player)entity4;
                }
            }
            if (player != null) {
                Object mob;
                PlayerData playerData = PlayerData.get(player);
                if (player.getMainHandItem().getItem() instanceof IOrgWeapon || player.getMainHandItem().getItem() instanceof KeybladeItem || event.getSource().getDirectEntity() instanceof KKThrowableEntity) {
                    int multiplier = EntityEvents.getMultiplier(event, player, playerData);
                    LivingEntity livingEntity = event.getEntity();
                    if (livingEntity instanceof IKHMob) {
                        mob = (IKHMob)livingEntity;
                        if (mob.getKHMobType() == EntityHelper.MobType.HEARTLESS_EMBLEM) {
                            playerData.addHearts((int)((double)(20 * multiplier) * (Double)ModConfigs.SERVER.heartMultiplier.get()));
                        }
                    } else if (event.getEntity() instanceof EnderDragon || event.getEntity() instanceof WitherBoss) {
                        playerData.addHearts((int)((double)(1000 * multiplier) * (Double)ModConfigs.SERVER.heartMultiplier.get()));
                    } else if (event.getEntity() instanceof Villager) {
                        playerData.addHearts((int)((double)(5 * multiplier) * (Double)ModConfigs.SERVER.heartMultiplier.get()));
                    } else if (event.getEntity() instanceof Monster) {
                        playerData.addHearts((int)((double)(2 * multiplier) * (Double)ModConfigs.SERVER.heartMultiplier.get()));
                    } else {
                        playerData.addHearts((int)((double)multiplier * (Double)ModConfigs.SERVER.heartMultiplier.get()));
                    }
                }
                if ((mob = event.getEntity()) instanceof IKHMob) {
                    IKHMob heartless = (IKHMob)mob;
                    if (heartless.getKHMobType() == EntityHelper.MobType.HEARTLESS_EMBLEM && Utils.getWeaponDamageStack(event.getSource(), player) != null && Utils.getWeaponDamageStack(event.getSource(), player).getItem() instanceof KeybladeItem) {
                        HeartEntity heart = new HeartEntity(event.getEntity().level());
                        heart.setPos(event.getEntity().getX(), event.getEntity().getY() + 1.0, event.getEntity().getZ());
                        event.getEntity().level().addFreshEntity((Entity)heart);
                    }
                    if (heartless.getKHMobType() == EntityHelper.MobType.HEARTLESS_PUREBLOOD && event.getEntity().level() instanceof ServerLevel) {
                        LivingEntity entity5 = event.getEntity();
                        for (int i = 0; i < 2; ++i) {
                            ((ServerLevel)entity5.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, entity5.getX() + entity5.level().random.nextDouble() / 2.0 - 0.25, entity5.getY() + entity5.level().random.nextDouble() / 2.0 - 0.25, entity5.getZ() + entity5.level().random.nextDouble() / 2.0 - 0.25, 50, 0.0, -1.0, 0.0, 0.3);
                            ((ServerLevel)entity5.level()).sendParticles((ParticleOptions)ParticleTypes.SQUID_INK, entity5.getX() + entity5.level().random.nextDouble() / 2.0 - 0.25, entity5.getY() + entity5.level().random.nextDouble() / 2.0 - 0.25, entity5.getZ() + entity5.level().random.nextDouble() / 2.0 - 0.25, 30, 0.0, -1.0, 0.0, 0.1);
                        }
                    }
                }
                if (event.getEntity().getClassification(false) == MobCategory.MONSTER) {
                    int num;
                    if (!playerData.isAbilityEquipped("kingdomkeys:ability_zero_exp")) {
                        LivingEntity mob2 = event.getEntity();
                        double value = mob2.getAttribute(Attributes.MAX_HEALTH).getValue() / 2.0;
                        double exp = Utils.randomWithRange(value * 0.8, value * 1.8);
                        playerData.addExperience(player, (int)(exp * (Double)ModConfigs.SERVER.xpMultiplier.get()), true, true);
                        if (event.getEntity() instanceof WitherBoss) {
                            playerData.addExperience(player, (int)((exp += 1500.0) * (Double)ModConfigs.SERVER.xpMultiplier.get()), true, true);
                        }
                        if (!playerData.isAbilityEquipped("kingdomkeys:ability_zero_exp")) {
                            if (playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost") > 0 && player.getHealth() <= player.getMaxHealth() / 2.0f) {
                                exp *= (double)(1 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost"));
                            }
                            XPEntity xp = new XPEntity(mob2.level(), player, mob2, exp);
                            player.level().addFreshEntity((Entity)xp);
                        }
                    }
                    LivingEntity entity22 = event.getEntity();
                    double x = entity22.getX();
                    double y = entity22.getY();
                    double z = entity22.getZ();
                    if (entity22.level().random.nextInt(100) <= ModConfigs.munnyDropProbability) {
                        num = (int)Utils.randomWithRange(5.0f, entity22.getMaxHealth() / 5.0f);
                        num = (int)((double)num + (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_jackpot") * 1.2);
                        entity22.level().addFreshEntity((Entity)new MunnyEntity(event.getEntity().level(), x, y, z, num /= 1 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_drive_converter")));
                    }
                    if (entity22.level().random.nextInt(100) <= ModConfigs.hpDropProbability) {
                        num = (int)Utils.randomWithRange(entity22.getMaxHealth() / 10.0f, entity22.getMaxHealth() / 5.0f);
                        num = (int)((double)num + (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_jackpot") * 1.2);
                        entity22.level().addFreshEntity((Entity)new HPOrbEntity(event.getEntity().level(), x, y, z, num));
                    }
                    if (entity22.level().random.nextInt(100) <= ModConfigs.mpDropProbability) {
                        num = (int)Utils.randomWithRange(entity22.getMaxHealth() / 10.0f, entity22.getMaxHealth() / 5.0f);
                        num = (int)((double)num + (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_jackpot") * 1.2);
                        entity22.level().addFreshEntity((Entity)new MPOrbEntity(event.getEntity().level(), x, y, z, num));
                    }
                    if (entity22.level().random.nextInt(100) <= ModConfigs.driveDropProbability) {
                        num = (int)((double)Utils.randomWithRange(entity22.getMaxHealth() * 0.1f, entity22.getMaxHealth() * 0.25f) * ModConfigs.drivePointsMultiplier);
                        num = (int)((double)num + (double)(num * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_drive_converter")) * 0.5);
                        entity22.level().addFreshEntity((Entity)new DriveOrbEntity(event.getEntity().level(), x, y, z, num));
                    }
                    if (entity22.level().random.nextInt(100) <= ModConfigs.focusDropProbability) {
                        num = (int)((double)Utils.randomWithRange(entity22.getMaxHealth() * 0.1f, entity22.getMaxHealth() * 0.25f) * ModConfigs.focusPointsMultiplier);
                        num = (int)((double)num + (double)(num * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_focus_converter")) * 0.25);
                        entity22.level().addFreshEntity((Entity)new FocusOrbEntity(event.getEntity().level(), x, y, z, num));
                    }
                    if ((num = Utils.randomWithRange(0, 99)) < (Integer)ModConfigs.SERVER.recipeDropChance.get() + Utils.getLootingLevel(player)) {
                        Item recipeTier = ModItems.recipeD.get();
                        GlobalData mobData = GlobalData.get(entity22);
                        if (mobData != null) {
                            int num2 = Utils.randomWithRange(0, mobData.getLevel() + 1);
                            if (num2 < 15) {
                                recipeTier = ModItems.recipeD.get();
                            } else if (num2 < 30) {
                                recipeTier = ModItems.recipeC.get();
                            } else if (num2 < 60) {
                                recipeTier = ModItems.recipeB.get();
                            } else if (num2 < 90) {
                                recipeTier = ModItems.recipeA.get();
                            } else if (num2 < 150) {
                                recipeTier = ModItems.recipeS.get();
                            } else if (num2 < 200) {
                                recipeTier = ModItems.recipeSS.get();
                            } else if (num2 == 200) {
                                recipeTier = ModItems.recipeSSS.get();
                            }
                        }
                        ItemEntity ie = new ItemEntity(player.level(), x, y, z, new ItemStack((ItemLike)recipeTier));
                        player.level().addFreshEntity((Entity)ie);
                    }
                    PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
                }
            }
            if (event.getEntity() instanceof MoogleEntity && event.getSource().getMsgId().equals("anvil")) {
                ItemEntity ie = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)ModBlocks.moogleProjector.get()));
                event.getEntity().level().addFreshEntity((Entity)ie);
            }
            if ((entity22 = event.getSource().getEntity()) instanceof IKHMob) {
                IKHMob killerMob = (IKHMob)entity22;
                if (ModConfigs.playerSpawnHeartless && !event.getSource().getEntity().hasCustomName() && (killerMob.getKHMobType() == EntityHelper.MobType.HEARTLESS_EMBLEM || killerMob.getKHMobType() == EntityHelper.MobType.HEARTLESS_PUREBLOOD)) {
                    if (event.getEntity() instanceof Player) {
                        PlayerData playerData = PlayerData.get((Player)event.getEntity());
                        String[] heartless = ModConfigs.playerSpawnHeartlessData.get(0).split(",");
                        String[] nobody = ModConfigs.playerSpawnHeartlessData.get(1).split(",");
                        DuskEntity newDusk = new DuskEntity(ModEntities.TYPE_DUSK.get(), event.getSource().getEntity().level());
                        newDusk.setPos(event.getEntity().blockPosition().getX(), event.getEntity().blockPosition().getY(), event.getEntity().blockPosition().getZ());
                        newDusk.setCustomName((Component)Component.translatable((String)(event.getEntity().getDisplayName().getString() + "'s Nobody")));
                        newDusk.getAttribute(Attributes.MAX_HEALTH).setBaseValue(Math.max((double)event.getEntity().getMaxHealth() * Double.parseDouble(nobody[1]) / 100.0, (double)newDusk.getMaxHealth()));
                        newDusk.heal(newDusk.getMaxHealth());
                        newDusk.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(Math.max((double)playerData.getStrength(true) * Double.parseDouble(nobody[2]) / 100.0, newDusk.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue()));
                        event.getSource().getEntity().level().addFreshEntity((Entity)newDusk);
                        ShadowEntity newShadow = new ShadowEntity(ModEntities.TYPE_SHADOW.get(), event.getSource().getEntity().level());
                        newShadow.setPos(event.getEntity().blockPosition().getX(), event.getEntity().blockPosition().getY(), event.getEntity().blockPosition().getZ());
                        newShadow.setCustomName((Component)Component.translatable((String)(event.getEntity().getDisplayName().getString() + "'s Heartless")));
                        newShadow.getAttribute(Attributes.MAX_HEALTH).setBaseValue(Math.max((double)event.getEntity().getMaxHealth() * Double.parseDouble(heartless[1]) / 100.0, (double)newShadow.getMaxHealth()));
                        newShadow.heal(newShadow.getMaxHealth());
                        newShadow.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(Math.max((double)playerData.getStrength(true) * Double.parseDouble(heartless[2]) / 100.0, newShadow.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue()));
                        event.getSource().getEntity().level().addFreshEntity((Entity)newShadow);
                        HeartEntity heart = new HeartEntity(event.getEntity().level());
                        heart.setPos(event.getEntity().getX(), event.getEntity().getY() + 1.0, event.getEntity().getZ());
                        event.getEntity().level().addFreshEntity((Entity)heart);
                    } else if (event.getEntity() instanceof Villager) {
                        ShadowEntity newShadow = new ShadowEntity(ModEntities.TYPE_SHADOW.get(), event.getSource().getEntity().level());
                        newShadow.setPos(event.getEntity().blockPosition().getX(), event.getEntity().blockPosition().getY(), event.getEntity().blockPosition().getZ());
                        event.getSource().getEntity().level().addFreshEntity((Entity)newShadow);
                        HeartEntity heart = new HeartEntity(event.getEntity().level());
                        heart.setPos(event.getEntity().getX(), event.getEntity().getY() + 1.0, event.getEntity().getZ());
                        event.getEntity().level().addFreshEntity((Entity)heart);
                    }
                }
            }
            if (event.getEntity() instanceof MarluxiaEntity && event.getSource().getEntity() instanceof Player && event.getSource().getEntity().level().dimension().equals(ModDimensions.STATION_OF_SORROW)) {
                ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld"));
                BlockPos coords = DimensionCommand.getWorldCoords(player, (ResourceKey<Level>)dimension);
                player.changeDimension(new DimensionTransition(player.getServer().getLevel(dimension), new Vec3((double)coords.getX(), (double)coords.getY(), (double)coords.getZ()), Vec3.ZERO, player.getYRot(), player.getXRot(), entity -> {}));
            }
        }
    }

    private static int getMultiplier(LivingDeathEvent event, Player player, PlayerData playerData) {
        IOrgWeapon weapon;
        int multiplier = 1;
        Item item = player.getMainHandItem().getItem();
        if (item instanceof IOrgWeapon && ((weapon = (IOrgWeapon)item).getMember() == playerData.getAlignment() || event.getSource().getDirectEntity() instanceof KKThrowableEntity && playerData.getAlignment() == Utils.OrgMember.AXEL)) {
            multiplier = 2;
        }
        return multiplier;
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        Player player;
        PlayerData playerData;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (playerData = PlayerData.get(player = (Player)livingEntity)) != null && playerData.getActiveDriveForm() != null) {
            if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                event.setDistance(0.0f);
            } else if (playerData.isAbilityEquipped("kingdomkeys:ability_high_jump") || playerData.isAbilityEquipped("kingdomkeys:ability_aerial_dodge") || playerData.isAbilityEquipped("kingdomkeys:ability_glide")) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getLevel().isClientSide() && !event.getPlayer().isCreative() && event.getPlayer().getMainHandItem().getEnchantmentLevel(event.getLevel().holderOrThrow(Enchantments.SILK_TOUCH)) == 0) {
            if (event.getState().getBlock() == ModBlocks.prizeBlox.get()) {
                event.getLevel().addFreshEntity((Entity)new MunnyEntity((Level)event.getLevel(), event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), Utils.randomWithRange(50, 200)));
            } else if (event.getState().getBlock() == ModBlocks.rarePrizeBlox.get()) {
                event.getLevel().addFreshEntity((Entity)new MunnyEntity((Level)event.getLevel(), event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), Utils.randomWithRange(300, 500)));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getEntity().level().isClientSide) {
            Player oPlayer = event.getOriginal();
            Player nPlayer = event.getEntity();
            nPlayer.setHealth((float)PlayerData.get(oPlayer).getMaxHP());
            nPlayer.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)PlayerData.get(oPlayer).getMaxHP());
            Utils.RefreshAbilityAttributes(nPlayer, PlayerData.get(nPlayer));
            PacketHandler.sendTo(new SCSyncWorldData(nPlayer.getServer()), (ServerPlayer)nPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().level().isClientSide) {
            Player nPlayer = event.getEntity();
            WorldData newWorldData = WorldData.get(nPlayer.getServer());
            PlayerData playerData = PlayerData.get(nPlayer);
            nPlayer.setHealth((float)playerData.getMaxHP());
            Utils.RefreshAbilityAttributes(nPlayer, playerData);
            PacketHandler.sendTo(new SCSyncWorldData(nPlayer.getServer()), (ServerPlayer)nPlayer);
            if (!event.isEndConquered() && !nPlayer.level().isClientSide() && playerData.getRespawnROD() && ModConfigs.respawnROD) {
                ServerPlayer sPlayer = (ServerPlayer)nPlayer;
                ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"realm_of_darkness"));
                ServerLevel serverlevel = ((ServerLevel)sPlayer.level()).getServer().getLevel(dimension);
                BlockPos pos = serverlevel.getSharedSpawnPos();
                sPlayer.changeDimension(new DimensionTransition(serverlevel, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), Vec3.ZERO, sPlayer.getYRot(), sPlayer.getXRot(), entity -> {}));
            }
        }
    }

    @SubscribeEvent
    public void onDimensionChanged(PlayerEvent.PlayerChangedDimensionEvent e) {
        Player player = e.getEntity();
        if (!player.level().isClientSide) {
            PlayerData playerData = PlayerData.get(player);
            ServerLevel world = player.getServer().getLevel(e.getTo());
            if (e.getTo() == ModDimensions.STATION_OF_SORROW) {
                BlockPos blockPos = player.blockPosition().below(2);
                world.setBlock(blockPos, ModBlocks.sorCore.get().defaultBlockState(), 2);
                BlockEntity blockEntity = world.getBlockEntity(blockPos);
                if (blockEntity instanceof SoRCoreTileEntity) {
                    SoRCoreTileEntity te = (SoRCoreTileEntity)blockEntity;
                    te.setUUID(player.getUUID());
                }
            }
            Utils.RefreshAbilityAttributes(player, playerData);
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            PacketHandler.sendTo(new SCSyncWorldData(world.getServer()), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public void playerStartedTracking(PlayerEvent.StartTracking e) {
        Player localPlayer = e.getEntity();
        PlayerData playerData = PlayerData.get(localPlayer);
        GlobalData globalData = GlobalData.get((LivingEntity)localPlayer);
        if (localPlayer == null || playerData == null || globalData == null) {
            return;
        }
        Entity entity = e.getTarget();
        if (entity instanceof Player) {
            Player targetPlayer = (Player)entity;
            PacketHandler.syncToAllAround(localPlayer, playerData);
            PacketHandler.syncToAllAround((LivingEntity)localPlayer, globalData);
            PlayerData targetPlayerData = PlayerData.get(targetPlayer);
            GlobalData globalData2 = GlobalData.get((LivingEntity)targetPlayer);
            PacketHandler.syncToAllAround(targetPlayer, targetPlayerData);
            PacketHandler.syncToAllAround((LivingEntity)targetPlayer, globalData2);
        }
        if (!localPlayer.level().isClientSide) {
            localPlayer.level().getServer().getPlayerList().getPlayers().forEach(sPlayer -> localPlayer.getActiveEffects().forEach(mobEffectInstance -> sPlayer.connection.send((Packet)new ClientboundUpdateMobEffectPacket(localPlayer.getId(), mobEffectInstance, false))));
        }
    }

    @SubscribeEvent
    public void playerStoppedTracking(PlayerEvent.StopTracking e) {
        if (!e.getEntity().level().isClientSide()) {
            Player player = e.getEntity();
            PlayerData playerData = PlayerData.get(player);
            WorldData worldData = WorldData.get(player.getServer());
            if (playerData == null || worldData == null) {
                return;
            }
            Party p = worldData.getPartyFromMember(player.getUUID());
            if (p == null) {
                return;
            }
            Party.Member m = p.getMember(player.getUUID());
            m.setLevel(playerData.getLevel());
            m.setHP((int)player.getMaxHealth());
            m.setMP((int)playerData.getMaxMP());
            PacketHandler.sendTo(new SCSyncWorldData(player.getServer()), (ServerPlayer)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void anvilUpdate(AnvilUpdateEvent event) {
        Item item = event.getLeft().getItem();
        if ((item instanceof KeybladeItem || item instanceof IOrgWeapon || item instanceof KeybladeArmorItem) && !event.getRight().isEmpty() && !(event.getRight().getItem() instanceof EnchantedBookItem)) {
            event.setOutput(ItemStack.EMPTY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void armourHurt(ArmorHurtEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().level().isClientSide() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            for (int i = 5; i > 2; --i) {
                ItemStack pauldron;
                PauldronInventory pauldronInventory;
                ItemStack stack = event.getArmorItemStack(EquipmentSlot.values()[i]);
                float damage = event.getNewDamage(EquipmentSlot.values()[i]).floatValue();
                if (stack.isEmpty() || stack.has(DataComponents.UNBREAKABLE) || stack.getMaxDamage() <= 0 || !((float)stack.getDamageValue() + damage >= (float)stack.getMaxDamage()) || !Utils.hasArmorID(stack) || (pauldronInventory = (PauldronInventory)((Object)(pauldron = PlayerData.get(player).getEquippedKBArmor(0)).getCapability(Capabilities.ItemHandler.ITEM))) == null) continue;
                pauldronInventory.setStackInSlot(-(i - 5), ItemStack.EMPTY);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void effectAdded(MobEffectEvent.Added event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        event.getEntity().level().getServer().getPlayerList().getPlayers().forEach(sPlayer -> sPlayer.connection.send((Packet)new ClientboundUpdateMobEffectPacket(event.getEntity().getId(), event.getEffectInstance(), false)));
    }

    @SubscribeEvent
    public void MobEffectRemove(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() != null) {
            Utils.removeEffects((Holder<MobEffect>)event.getEffect(), event.getEntity());
        }
    }

    @SubscribeEvent
    public void MobEffectExpire(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null) {
            Utils.removeEffects((Holder<MobEffect>)event.getEffectInstance().getEffect(), event.getEntity());
        }
    }
}

