/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.handler;

import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.api.event.client.KKInputEvent;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.mob.SpawningOrbEntity;
import online.kingdomkeys.kingdomkeys.handler.KeyboardHelper;
import online.kingdomkeys.kingdomkeys.integration.epicfight.EpicFightUtils;
import online.kingdomkeys.kingdomkeys.lib.Constants;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSExtendedReach;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonArmor;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseReactionCommandPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseShortcutPacket;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.util.IExtendedReach;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class InputHandler {
    @Nullable
    public List<UUID> portalCommands;
    @Nullable
    public List<Party.Member> targetsList;
    @Nullable
    public List<Limit> limitsList;
    @Nullable
    public List<String> magicList;
    @Nullable
    public Map<Integer, ItemStack> itemsList;
    @Nullable
    public List<String> reactionList;
    @Nullable
    public static LivingEntity lockOn = null;
    public static int qrCooldown = 40;
    public Minecraft mc = Minecraft.getInstance();
    public LocalPlayer player;
    @Nullable
    public ClientLevel level;
    public PlayerData playerData;
    public GlobalData globalData;
    @Nullable
    public WorldData worldData;
    boolean canSwitchTarget = true;
    public static int LOCK_ON_REACH = 35;

    private void init() {
        this.player = this.mc.player;
        this.level = this.mc.level;
        if (this.level != null) {
            this.worldData = WorldData.getClient();
        }
        if (this.player != null) {
            this.playerData = PlayerData.get((Player)this.player);
            this.globalData = GlobalData.get((LivingEntity)this.player);
        }
    }

    @SubscribeEvent
    public void handleKeyInputEvent(InputEvent.Key event) {
        this.init();
        if (lockOn != null) {
            if (this.canSwitchTarget && event.getKey() == this.mc.options.keySprint.getKey().getValue()) {
                this.switchTarget(this.player.isCrouching());
                this.canSwitchTarget = false;
            } else {
                this.canSwitchTarget = true;
            }
        }
        Keybinds key = this.getPressedKey();
        if (this.player != null) {
            if (this.playerData == null) {
                return;
            }
            if (key != null) {
                if (!((KKInputEvent.Pre)NeoForge.EVENT_BUS.post((Event)new KKInputEvent.Pre(key, this))).isCanceled()) {
                    switch (key.ordinal()) {
                        case 0: {
                            this.openMenu();
                            break;
                        }
                        case 8: {
                            this.showGui();
                            break;
                        }
                        case 1: {
                            if (this.mc.screen != null || !Utils.shouldRenderOverlay((Player)this.player)) break;
                            this.commandUp();
                            break;
                        }
                        case 2: {
                            if (this.mc.screen != null || !Utils.shouldRenderOverlay((Player)this.player)) break;
                            this.commandDown();
                            break;
                        }
                        case 3: {
                            if (this.mc.screen != null || !Utils.shouldRenderOverlay((Player)this.player)) break;
                            this.commandEnter();
                            break;
                        }
                        case 4: {
                            if (this.mc.screen != null || !Utils.shouldRenderOverlay((Player)this.player)) break;
                            this.commandBack();
                            break;
                        }
                        case 6: {
                            this.summonKeyblade();
                            break;
                        }
                        case 10: {
                            this.summonArmor();
                            break;
                        }
                        case 9: {
                            this.commandAction();
                            break;
                        }
                        case 7: {
                            this.lockOn();
                            break;
                        }
                        case 11: {
                            this.reactionCommand();
                        }
                    }
                    NeoForge.EVENT_BUS.post((Event)new KKInputEvent.Post(key, this));
                }
            } else {
                this.otherKeyPressed(event);
            }
        }
    }

    @SubscribeEvent
    public void handleMouseInputEvent(InputEvent.MouseButton.Pre event) {
        this.init();
        if (this.level != null) {
            if (event.getButton() == 0 && event.getAction() == 1) {
                ItemStack itemstack;
                if (KeyboardHelper.isScrollActivatorDown() && Utils.shouldRenderOverlay((Player)this.player)) {
                    this.commandEnter();
                    event.setCanceled(true);
                } else if (this.mc.screen == null && this.player != null && !ItemStack.matches((ItemStack)(itemstack = this.player.getMainHandItem()), (ItemStack)ItemStack.EMPTY)) {
                    EntityHitResult ertr;
                    float reach;
                    HitResult rtr;
                    IExtendedReach ieri;
                    IExtendedReach iExtendedReach = ieri = itemstack.getItem() instanceof IExtendedReach ? (IExtendedReach)itemstack.getItem() : null;
                    if (ieri != null && (rtr = InputHandler.getMouseOverExtended(reach = ieri.getReach())) != null && rtr instanceof EntityHitResult && (ertr = (EntityHitResult)rtr).getEntity() != null && ertr.getEntity().invulnerableTime == 0 && ertr.getEntity() != this.player && !ertr.getEntity().getPassengers().contains(this.player)) {
                        PacketHandler.sendToServer(new CSExtendedReach(ertr.getEntity().getId()));
                    }
                }
            }
            if (event.getButton() == 2 && KeyboardHelper.isScrollActivatorDown() && event.getAction() == 1 && Utils.shouldRenderOverlay((Player)this.player)) {
                this.commandSwapReaction();
                event.setCanceled(true);
            }
            if (event.getButton() == 1 && KeyboardHelper.isScrollActivatorDown() && event.getAction() == 1 && Utils.shouldRenderOverlay((Player)this.player)) {
                this.commandBack();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void OnMouseWheelScroll(InputEvent.MouseScrollingEvent event) {
        this.init();
        if (this.mc.isWindowActive() && KeyboardHelper.isScrollActivatorDown()) {
            event.setCanceled(true);
            if (!Utils.shouldRenderOverlay((Player)this.player)) {
                return;
            }
            if (event.getScrollDeltaY() == -1.0) {
                this.commandDown();
            } else if (event.getScrollDeltaY() == 1.0) {
                this.commandUp();
            }
        }
    }

    public void showGui() {
        ModConfigs.toggleGui();
        this.player.displayClientMessage((Component)Component.translatable((String)"message.kingdomkeys.gui_toggle", (Object[])new Object[]{ModConfigs.showGuiToggle.toString()}), true);
    }

    public void openMenu() {
        PacketHandler.sendToServer(new CSOpenMenu());
    }

    public void summonKeyblade() {
        if (this.playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
            if (EpicFightUtils.isBattleMode((Player)this.player)) {
                if (!(Utils.findSummoned(this.player.getInventory(), this.playerData.getEquippedKeychain(DriveForm.NONE)) == -1 && this.playerData.getAlignment() == Utils.OrgMember.NONE || Utils.findSummoned(this.player.getInventory(), this.playerData.getEquippedWeapon()) == -1 && this.playerData.getAlignment() != Utils.OrgMember.NONE)) {
                    PacketHandler.sendToServer(new CSSummonKeyblade());
                }
            } else {
                PacketHandler.sendToServer(new CSSummonKeyblade());
            }
        } else if (!EpicFightUtils.isBattleMode((Player)this.player) || Utils.findSummoned(this.player.getInventory(), this.playerData.getEquippedKeychain(DriveForm.NONE)) != -1) {
            PacketHandler.sendToServer(new CSSummonKeyblade(ResourceLocation.parse((String)this.playerData.getActiveDriveForm())));
        }
        if (ModConfigs.summonTogether) {
            PacketHandler.sendToServer(new CSSummonArmor());
        }
    }

    public void summonArmor() {
        PacketHandler.sendToServer(new CSSummonArmor());
    }

    public void lockOn() {
        if (lockOn == null) {
            EntityHitResult ertr;
            double distance;
            HitResult rtr = InputHandler.getMouseOverExtended(LOCK_ON_REACH);
            if (rtr instanceof EntityHitResult && (double)LOCK_ON_REACH >= (distance = (double)this.player.distanceTo((ertr = (EntityHitResult)rtr).getEntity())) && ertr.getEntity() instanceof LivingEntity && !(ertr.getEntity() instanceof SpawningOrbEntity)) {
                lockOn = (LivingEntity)ertr.getEntity();
                this.playSound((SoundEvent)ModSounds.lockon.get());
            }
        } else {
            lockOn = null;
        }
    }

    private void switchTarget(boolean toRight) {
        int nextIndex;
        LivingEntity nextTarget;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || lockOn == null) {
            return;
        }
        LivingEntity currentTarget = lockOn;
        List candidates = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate((double)((float)LOCK_ON_REACH / 4.0f)), arg_0 -> InputHandler.lambda$switchTarget$0((Player)player, arg_0));
        if (candidates.size() <= 1) {
            return;
        }
        Vec3 playerPos = player.position();
        Vec3 lookVec = player.getLookAngle();
        List<Pair> sorted = candidates.stream().map(entity -> {
            Vec3 dirToEntity = entity.position().subtract(playerPos).normalize();
            double angle = Math.toDegrees(Math.atan2(lookVec.z * dirToEntity.x - lookVec.x * dirToEntity.z, lookVec.x * dirToEntity.x + lookVec.z * dirToEntity.z));
            return Pair.of((Object)entity, (Object)angle);
        }).sorted(Comparator.comparingDouble(Pair::getSecond)).toList();
        int index = -1;
        for (int i = 0; i < sorted.size(); ++i) {
            if (!((LivingEntity)sorted.get(i).getFirst()).equals((Object)currentTarget)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = 0;
        }
        if ((nextTarget = (LivingEntity)sorted.get(nextIndex = (index + (toRight ? 1 : -1) + sorted.size()) % sorted.size()).getFirst()).equals((Object)currentTarget)) {
            return;
        }
        lockOn = nextTarget;
        this.playSound((SoundEvent)ModSounds.lockon.get());
    }

    public void commandUp() {
        CommandMenuGui.up();
    }

    public void commandDown() {
        CommandMenuGui.down();
    }

    public void commandEnter() {
        CommandMenuGui.enter();
    }

    public void commandBack() {
        CommandMenuGui.cancel();
    }

    public void commandAction() {
        if (qrCooldown <= 0 && this.player.getDeltaMovement().x != 0.0 && this.player.getDeltaMovement().z != 0.0) {
            if (this.player.isSprinting()) {
                if (this.playerData.isAbilityEquipped("kingdomkeys:ability_quick_run") || this.playerData.getActiveDriveForm().equals("kingdomkeys:form_wisdom")) {
                    this.quickRun();
                }
            } else if (this.playerData.isAbilityEquipped("kingdomkeys:ability_dodge_roll") || this.playerData.getActiveDriveForm().equals("kingdomkeys:form_limit")) {
                this.dodgeRoll();
            }
        }
    }

    public void quickRun() {
        float yaw = this.player.getYRot();
        float motionX = -Mth.sin((float)(yaw / 180.0f * (float)Math.PI));
        float motionZ = Mth.cos((float)(yaw / 180.0f * (float)Math.PI));
        int wisdomLevel = this.playerData.getDriveFormLevel("kingdomkeys:form_wisdom");
        double power = 0.0;
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.playerData.getActiveDriveForm()));
        if (this.playerData.getActiveDriveForm().equals("kingdomkeys:form_wisdom")) {
            power = Constants.WISDOM_QR[wisdomLevel];
        } else if ((this.playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities()) && wisdomLevel > 2) {
            power = Constants.WISDOM_QR[wisdomLevel - 2];
        }
        if (this.player.onGround()) {
            this.player.push((double)motionX * power, 0.0, (double)motionZ * power);
            qrCooldown = 20;
        }
    }

    public void dodgeRoll() {
        int limitLevel = this.playerData.getDriveFormLevel("kingdomkeys:form_limit");
        double power = 0.0;
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.playerData.getActiveDriveForm()));
        if (this.playerData.getActiveDriveForm().equals("kingdomkeys:form_limit")) {
            power = Constants.LIMIT_DR[limitLevel];
        } else if ((this.playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities()) && limitLevel > 2) {
            power = Constants.LIMIT_DR[limitLevel - 2];
        }
        if (this.player.onGround()) {
            this.player.push(this.player.getDeltaMovement().x * power, 0.0, this.player.getDeltaMovement().z * power);
            qrCooldown = 20;
        }
    }

    public void commandSwapReaction() {
        this.loadLists();
        if (this.reactionList != null && !this.reactionList.isEmpty()) {
            if (CommandMenuGui.reactionSelected < this.reactionList.size() - 1) {
                ++CommandMenuGui.reactionSelected;
            } else if (CommandMenuGui.reactionSelected >= this.reactionList.size() - 1) {
                CommandMenuGui.reactionSelected = 0;
            }
        }
    }

    public void reactionCommand() {
        this.loadLists();
        if (!this.reactionList.isEmpty()) {
            PacketHandler.sendToServer(new CSUseReactionCommandPacket(CommandMenuGui.reactionSelected, lockOn));
            String reactionName = this.playerData.getReactionCommands().get(CommandMenuGui.reactionSelected);
            ReactionCommand reaction = (ReactionCommand)ModReactionCommands.registry.get(ResourceLocation.parse((String)reactionName));
            CommandMenuGui.reactionSelected = 0;
            if (reaction != null) {
                this.playSound(reaction.getUseSound((Player)this.player, lockOn));
            } else {
                this.playInSound();
            }
        }
    }

    public void otherKeyPressed(InputEvent.Key event) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.playerData.getActiveDriveForm()));
        if (KeyboardHelper.isScrollActivatorDown() && event.getKey() > 320 && event.getKey() < 330 && this.globalData != null && !this.player.hasEffect(ModMobEffects.STOP) && this.playerData.getMagicCasttimeTicks() <= 0 && this.playerData.getMagicCooldownTicks() <= 0 && !this.playerData.getRecharge() && form.canUseMagic() && !this.player.hasEffect(ModMobEffects.KO)) {
            PacketHandler.sendToServer(new CSUseShortcutPacket(event.getKey() - 321, lockOn));
        }
        if (KeyboardHelper.isScrollActivatorDown() && event.getKey() > 48 && event.getKey() < 58 && this.globalData != null && !this.player.hasEffect(ModMobEffects.STOP) && this.playerData.getMagicCasttimeTicks() <= 0 && this.playerData.getMagicCooldownTicks() <= 0 && !this.playerData.getRecharge() && form.canUseMagic() && !this.player.hasEffect(ModMobEffects.KO)) {
            PacketHandler.sendToServer(new CSUseShortcutPacket(event.getKey() - 49, lockOn));
        }
    }

    public void loadLists() {
        if (this.playerData != null && this.worldData != null) {
            this.portalCommands = this.worldData.getAllPortalsFromOwnerID(this.player.getUUID());
            this.magicList = ModConfigs.magicDisplayedInCommandMenu.stream().filter(magic -> this.playerData.getMagicsMap().containsKey(magic)).toList();
            this.limitsList = Utils.getSortedLimits(Utils.getPlayerLimitAttacks((Player)this.player));
            if (this.worldData.getPartyFromMember(this.player.getUUID()) != null) {
                this.targetsList = this.worldData.getPartyFromMember(this.player.getUUID()).getMembers();
            }
            this.itemsList = Utils.getEquippedItems(this.playerData.getEquippedItems());
            this.reactionList = this.playerData.getReactionCommands();
        }
    }

    public void playSelectSound() {
        this.playSound((SoundEvent)ModSounds.menu_select.get());
    }

    public void playMoveSound() {
        this.playSound((SoundEvent)ModSounds.menu_move.get());
    }

    public void playBackSound() {
        this.playSound((SoundEvent)ModSounds.menu_back.get());
    }

    public void playInSound() {
        this.playSound((SoundEvent)ModSounds.menu_in.get());
    }

    public void playErrorSound() {
        this.playSound((SoundEvent)ModSounds.error.get());
    }

    public void playSound(SoundEvent sound) {
        this.level.playSound((Player)this.player, this.player.position().x(), this.player.position().y(), this.player.position().z(), sound, SoundSource.MASTER, 1.0f, 1.0f);
    }

    public static HitResult getMouseOverExtended(float dist) {
        Minecraft mc = Minecraft.getInstance();
        Entity theRenderViewEntity = mc.getCameraEntity();
        AABB theViewBoundingBox = new AABB(theRenderViewEntity.getX() - 0.5, theRenderViewEntity.getY() - 0.0, theRenderViewEntity.getZ() - 0.5, theRenderViewEntity.getX() + 0.5, theRenderViewEntity.getY() + 1.5, theRenderViewEntity.getZ() + 0.5);
        HitResult returnMOP = null;
        if (mc.level != null) {
            double var2 = dist;
            returnMOP = theRenderViewEntity.pick(var2, 0.0f, false);
            double calcdist = var2;
            Vec3 pos = theRenderViewEntity.getEyePosition(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.getLocation().distanceTo(pos);
            }
            Vec3 lookvec = theRenderViewEntity.getViewVector(0.0f);
            Vec3 var8 = pos.add(lookvec.x * var2, lookvec.y * var2, lookvec.z * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.level.getEntities(theRenderViewEntity, theViewBoundingBox.inflate(lookvec.x * var2, lookvec.y * var2, lookvec.z * var2).inflate((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                if (!entity.isPickable()) continue;
                float bordersize = entity.getPickRadius();
                AABB aabb = new AABB(entity.getX() - (double)(entity.getBbWidth() / 2.0f), entity.getY(), entity.getZ() - (double)(entity.getBbWidth() / 2.0f), entity.getX() + (double)(entity.getBbWidth() / 2.0f), entity.getY() + (double)entity.getBbHeight(), entity.getZ() + (double)(entity.getBbWidth() / 2.0f));
                aabb.inflate((double)bordersize, (double)bordersize, (double)bordersize);
                Optional mop0 = aabb.clip(pos, var8);
                if (aabb.contains(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !mop0.isPresent() || !((d1 = pos.distanceTo((Vec3)mop0.get())) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                returnMOP = new EntityHitResult(pointedEntity);
            }
        }
        return returnMOP;
    }

    private Keybinds getPressedKey() {
        for (Keybinds key : Keybinds.values()) {
            if (!key.isPressed()) continue;
            return key;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$switchTarget$0(Player player, LivingEntity e) {
        return e != player && !e.isDeadOrDying() && e.isAlive();
    }

    public static enum Keybinds {
        OPENMENU("key.kingdomkeys.openmenu", 77),
        SCROLL_UP("key.kingdomkeys.scrollup", 265),
        SCROLL_DOWN("key.kingdomkeys.scrolldown", 264),
        ENTER("key.kingdomkeys.enter", 262),
        BACK("key.kingdomkeys.back", 263),
        SCROLL_ACTIVATOR("key.kingdomkeys.scrollactivator", 342),
        SUMMON_KEYBLADE("key.kingdomkeys.summonkeyblade", 71),
        LOCK_ON("key.kingdomkeys.lockon", 90),
        SHOW_GUI("key.kingdomkeys.showgui", 79),
        ACTION("key.kingdomkeys.action", 88),
        SUMMON_ARMOR("key.kingdomkeys.summonarmor", 72),
        REACTION_COMMAND("key.kingdomkeys.reactioncommand", 82);

        public final KeyMapping keybinding;
        public final String translationKey;

        private Keybinds(String name, int defaultKey) {
            this.keybinding = new KeyMapping(name, defaultKey, "key.categories.kingdomkeys");
            this.translationKey = name;
        }

        public KeyMapping getKeybind() {
            return this.keybinding;
        }

        private boolean isPressed() {
            return this.keybinding.consumeClick();
        }
    }
}

