/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.integration.jei;

import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.integration.jei.TextDrawable;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SynthesisRecipeCategory
implements IRecipeCategory<Recipe> {
    IDrawable icon;
    IDrawable background;
    IDrawable munny;
    public static final RecipeType<Recipe> TYPE = RecipeType.create((String)"kingdomkeys", (String)"synthesis", Recipe.class);

    public SynthesisRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.moogleProjector.get()));
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/synthesis_recipe_background.png"), 0, 0, 170, 86).build();
        this.munny = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/munny.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.getCost() > 0) {
            this.munny.draw(guiGraphics, 5, 57);
            new TextDrawable((Component)Component.translatable((String)String.valueOf(recipe.getCost())), 0xFFFF55).draw(guiGraphics, 5, 57);
        }
        new TextDrawable((Component)Component.translatable((String)(Utils.translateToLocal("gui.shop.tier", new Object[0]) + " " + Utils.getTierFromInt(recipe.getTier()))), 0xFFFF55).draw(guiGraphics, 70, 57);
        PlayerData playerData = PlayerData.get((Player)Minecraft.getInstance().player);
        if (playerData != null) {
            if (playerData.hasKnownRecipe(recipe.getRegistryName())) {
                new TextDrawable((Component)Component.translatable((String)"jei.category.kingdomkeys.synthesis.unlocked"), 0x55FF55).draw(guiGraphics, 5, 72);
            } else {
                new TextDrawable((Component)Component.translatable((String)"jei.category.kingdomkeys.synthesis.locked"), 0xFF5555).draw(guiGraphics, 5, 72);
            }
        }
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.category.kingdomkeys.synthesis");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 145, 62).addItemStack(new ItemStack((ItemLike)recipe.getResult()))).setSlotName("result");
        int startX = 5;
        int startY = 4;
        int currentX = startX;
        int currentY = startY;
        for (Map.Entry<Item, Integer> ingredient : recipe.getMaterials().entrySet()) {
            TextDrawable quantityOverlay = new TextDrawable((Component)Component.translatable((String)ingredient.getValue().toString()));
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, currentX, currentY).addItemStack(new ItemStack((ItemLike)ingredient.getKey()))).setSlotName(BuiltInRegistries.ITEM.getKey((Object)ingredient.getKey()).toString()).setOverlay((IDrawable)quantityOverlay, 16 - quantityOverlay.getWidth(), 16 - quantityOverlay.getHeight());
            if ((currentX += 16) <= 164) continue;
            currentY += 16;
            currentX = startX;
        }
    }

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }
}

