/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class BaseArmorItem
extends ArmorItem
implements IItemCategory {
    String textureName;

    public BaseArmorItem(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, String textureName) {
        super(materialIn, slot, new Item.Properties().stacksTo(1));
        this.textureName = textureName;
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        if (this.textureName != null) {
            if (slot == EquipmentSlot.LEGS) {
                return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("textures/models/armor/" + this.textureName + "_layer_2.png"));
            }
            if (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.FEET) {
                return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("textures/models/armor/" + this.textureName + "_layer_1.png"));
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (flagIn.isAdvanced() && Utils.hasArmorID(stack)) {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "DEBUG:")));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.WHITE) + Utils.getArmorID(stack).toString())));
        }
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Utils.armourTick(stack, entityIn, worldIn, itemSlot);
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.EQUIPMENT;
    }

    @EventBusSubscriber
    public static class BaseArmorItemEvents {
        @SubscribeEvent
        public static void onItemDropped(EntityJoinLevelEvent event) {
            ItemStack droppedItem;
            UUID droppedID;
            if (event.getEntity() instanceof ItemEntity && (droppedID = Utils.getArmorID(droppedItem = ((ItemEntity)event.getEntity()).getItem())) != null && droppedItem.getItem() instanceof BaseArmorItem) {
                event.setCanceled(true);
            }
        }
    }
}

