/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class DriveFormOrbItem
extends Item {
    String formName;

    public DriveFormOrbItem(Item.Properties properties, String name) {
        super(properties);
        this.formName = name;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        PlayerData playerData;
        if (!world.isClientSide && (playerData = PlayerData.get(player)) != null && playerData.getDriveFormMap() != null) {
            DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.formName));
            if (playerData.getDriveFormMap().containsKey(this.formName)) {
                int level;
                int n = level = playerData.getDriveFormMap().containsKey(this.formName) ? playerData.getDriveFormMap().get(this.formName)[0] + 1 : 1;
                if (level <= 7) {
                    int exp = form.getLevelUpCost(level);
                    int oldExp = 0;
                    if (level > 1) {
                        oldExp = form.getLevelUpCost(level - 1);
                    }
                    int newExp = exp - oldExp;
                    int finalExp = Math.max(newExp / 10, 1);
                    playerData.setDriveFormExp(player, this.formName, playerData.getDriveFormExp(this.formName) + finalExp);
                    String message = Utils.translateToLocal("gui.driveformorb.upgrade", Utils.translateToLocal(form.getTranslationKey(), new Object[0]), finalExp);
                    player.displayClientMessage((Component)Component.translatable((String)message), true);
                    if (!ItemStack.matches((ItemStack)player.getMainHandItem(), (ItemStack)ItemStack.EMPTY) && player.getMainHandItem().getItem() == this) {
                        player.getMainHandItem().shrink(1);
                    } else if (!ItemStack.matches((ItemStack)player.getOffhandItem(), (ItemStack)ItemStack.EMPTY) && player.getOffhandItem().getItem() == this) {
                        player.getOffhandItem().shrink(1);
                    }
                }
            } else {
                playerData.setDriveFormLevel(this.formName, 1);
                playerData.setNewKeychain(ResourceLocation.parse((String)this.formName), ItemStack.EMPTY);
                player.displayClientMessage((Component)Component.translatable((String)"message.form_unlocked", (Object[])new Object[]{Utils.translateToLocal(form.getTranslationKey(), new Object[0])}), true);
                if (!ItemStack.matches((ItemStack)player.getMainHandItem(), (ItemStack)ItemStack.EMPTY) && player.getMainHandItem().getItem() == this) {
                    player.getMainHandItem().shrink(1);
                } else if (!ItemStack.matches((ItemStack)player.getOffhandItem(), (ItemStack)ItemStack.EMPTY) && player.getOffhandItem().getItem() == this) {
                    player.getOffhandItem().shrink(1);
                }
            }
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.formName));
        if (form != null) {
            tooltip.add((Component)Component.translatable((String)Utils.translateToLocal("gui.driveformorb.tooltip", Utils.translateToLocal(form.getTranslationKey(), new Object[0]))));
        }
        super.appendHoverText(pStack, pContext, tooltip, pTooltipFlag);
    }
}

