/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KKAccessoryItem
extends Item
implements IItemCategory {
    int ap;
    int str;
    int mag;
    String[] abilities;

    public KKAccessoryItem(Item.Properties properties, int AP, int str, int mag, String[] abilities) {
        super(properties);
        this.ap = AP;
        this.str = str;
        this.mag = mag;
        this.abilities = abilities;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.getAp() != 0) {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.YELLOW) + Utils.translateToLocal("gui.menu.status.ap", new Object[0]) + ": " + this.getAp())));
        }
        if (this.getStr() != 0) {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + Utils.translateToLocal("gui.menu.status.strength", new Object[0]) + ": " + this.getStr())));
        }
        if (this.getMag() != 0) {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.BLUE) + Utils.translateToLocal("gui.menu.status.magic", new Object[0]) + ": " + this.getMag())));
        }
        if (!this.getAbilities().isEmpty()) {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.GOLD) + Utils.translateToLocal("gui.menu.status.abilities", new Object[0]) + ":")));
            for (String a : this.getAbilities()) {
                Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)a));
                if (ability == null) continue;
                tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.GOLD) + "- " + Utils.translateToLocal(ability.getTranslationKey(), new Object[0]))));
            }
        }
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }

    public int getAp() {
        return this.ap;
    }

    public void setAp(int ap) {
        this.ap = ap;
    }

    public int getStr() {
        return this.str;
    }

    public void setStr(int str) {
        this.str = str;
    }

    public int getMag() {
        return this.mag;
    }

    public void setMag(int mag) {
        this.mag = mag;
    }

    public List<String> getAbilities() {
        return this.abilities == null ? Lists.newArrayList() : Lists.newArrayList((Object[])this.abilities);
    }

    public void setAbilities(String[] abilities) {
        this.abilities = abilities;
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.ACCESSORIES;
    }

    public String toString() {
        return super.toString();
    }
}

