/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KKArmorItem
extends Item
implements IItemCategory {
    private final int defence;
    private final ImmutableMap<KKResistanceType, Integer> resList;

    public KKArmorItem(Item.Properties properties, int defense, ImmutableMap<KKResistanceType, Integer> resList) {
        super(properties);
        this.defence = defense;
        this.resList = resList;
    }

    public int getDefense() {
        return this.defence;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.getDefense() != 0) {
            tooltip.add((Component)Component.translatable((String)(Utils.translateToLocal("gui.menu.status.defense", new Object[0]) + ": " + this.getDefense())));
        }
        for (Map.Entry resistanceType : this.resList.entrySet()) {
            switch ((KKResistanceType)((Object)resistanceType.getKey())) {
                case fire: {
                    tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + Utils.translateToLocal("gui.menu.status.fireres", new Object[0]) + ": " + String.valueOf(resistanceType.getValue()) + "%")));
                    break;
                }
                case ice: {
                    tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.AQUA) + Utils.translateToLocal("gui.menu.status.blizzardres", new Object[0]) + ": " + String.valueOf(resistanceType.getValue()) + "%")));
                    break;
                }
                case lightning: {
                    tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.YELLOW) + Utils.translateToLocal("gui.menu.status.thunderres", new Object[0]) + ": " + String.valueOf(resistanceType.getValue()) + "%")));
                    break;
                }
                case light: {
                    tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.WHITE) + Utils.translateToLocal("gui.menu.status.lightres", new Object[0]) + ": " + String.valueOf(resistanceType.getValue()) + "%")));
                    break;
                }
                case darkness: {
                    tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.GRAY) + Utils.translateToLocal("gui.menu.status.darkres", new Object[0]) + ": " + String.valueOf(resistanceType.getValue()) + "%")));
                }
            }
        }
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }

    public boolean CheckKey(KKResistanceType kkResistanceType) {
        return this.resList.containsKey((Object)kkResistanceType);
    }

    public int GetResValue(KKResistanceType kkResistanceType) {
        return (Integer)this.resList.get((Object)kkResistanceType);
    }

    public int GetResValue(KKResistanceType kkResistanceType, int total) {
        return (Integer)this.resList.get((Object)kkResistanceType) * total / 100;
    }

    public ImmutableMap<KKResistanceType, Integer> getResList() {
        return this.resList;
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.EQUIPMENT;
    }
}

