/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KKPotionItem
extends Item
implements IItemCategory {
    PotionType type;
    double amount;
    boolean percentage;
    boolean all;

    public KKPotionItem(Item.Properties properties, PotionType type, double amount, boolean perc, boolean all) {
        super(properties);
        this.type = type;
        this.amount = amount;
        this.percentage = perc;
        this.all = all;
    }

    public void potionEffect(Player player) {
        PlayerData playerData = PlayerData.get(player);
        switch (this.type.ordinal()) {
            case 0: {
                WorldData worldData;
                Party party;
                float hpAmount = (float)(this.percentage ? (double)player.getMaxHealth() * this.amount / 100.0 : this.amount);
                hpAmount += hpAmount * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_item_boost") / 2.0f;
                player.heal(hpAmount);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                Utils.reviveFromKO((LivingEntity)player);
                if (!this.all || (party = (worldData = WorldData.get(player.getServer())).getPartyFromMember(player.getUUID())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    Player target;
                    if (m.getUUID().equals(player.getUUID()) || !((target = player.level().getPlayerByUUID(m.getUUID())).distanceTo((Entity)player) < (float)((Integer)ModConfigs.SERVER.partyRangeLimit.get()).intValue())) continue;
                    hpAmount = (float)(this.percentage ? (double)target.getMaxHealth() * this.amount / 100.0 : this.amount);
                    hpAmount += hpAmount * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_item_boost") / 2.0f;
                    target.heal(hpAmount);
                    Utils.reviveFromKO((LivingEntity)target);
                    player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                break;
            }
            case 1: {
                WorldData worldData;
                Party party;
                float mpAmount = (float)(this.percentage ? playerData.getMaxMP() * this.amount / 100.0 : this.amount);
                playerData.addMP(mpAmount);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = WorldData.get(player.getServer())).getPartyFromMember(player.getUUID())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    if (m.getUUID().equals(player.getUUID())) continue;
                    Player target = player.level().getPlayerByUUID(m.getUUID());
                    PlayerData targetData = PlayerData.get(target);
                    if (target.distanceTo((Entity)player) < (float)((Integer)ModConfigs.SERVER.partyRangeLimit.get()).intValue()) {
                        mpAmount = (float)(this.percentage ? targetData.getMaxMP() * this.amount / 100.0 : this.amount);
                        targetData.addMP(mpAmount);
                        player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    PacketHandler.syncToAllAround(target, targetData);
                }
                break;
            }
            case 2: {
                WorldData worldData;
                Party party;
                float mpAmount = (float)(this.percentage ? playerData.getMaxMP() * this.amount / 100.0 : this.amount);
                float hpAmount = (float)(this.percentage ? (double)player.getMaxHealth() * this.amount / 100.0 : this.amount);
                hpAmount += hpAmount * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_item_boost") / 2.0f;
                playerData.addMP(mpAmount);
                Utils.reviveFromKO((LivingEntity)player);
                player.heal(hpAmount);
                player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = WorldData.get(player.getServer())).getPartyFromMember(player.getUUID())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    if (m.getUUID().equals(player.getUUID())) continue;
                    Player target = player.level().getPlayerByUUID(m.getUUID());
                    PlayerData targetData = PlayerData.get(target);
                    if (target.distanceTo((Entity)player) < (float)((Integer)ModConfigs.SERVER.partyRangeLimit.get()).intValue()) {
                        mpAmount = (float)(this.percentage ? targetData.getMaxMP() * this.amount / 100.0 : this.amount);
                        hpAmount = (float)(this.percentage ? (double)target.getMaxHealth() * this.amount / 100.0 : this.amount);
                        hpAmount += hpAmount * (float)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_item_boost") / 2.0f;
                        Utils.reviveFromKO((LivingEntity)target);
                        targetData.addMP(mpAmount);
                        target.heal(hpAmount);
                        player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    PacketHandler.syncToAllAround(target, targetData);
                }
                break;
            }
            case 3: {
                WorldData worldData;
                Party party;
                float dpAmount = (float)(this.percentage ? playerData.getMaxDP() * this.amount / 100.0 : this.amount);
                playerData.addDP(dpAmount);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = WorldData.get(player.getServer())).getPartyFromMember(player.getUUID())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    if (m.getUUID().equals(player.getUUID())) continue;
                    Player target = player.level().getPlayerByUUID(m.getUUID());
                    PlayerData targetData = PlayerData.get(target);
                    if (target.distanceTo((Entity)player) < (float)((Integer)ModConfigs.SERVER.partyRangeLimit.get()).intValue()) {
                        dpAmount = (float)(this.percentage ? targetData.getMaxDP() * this.amount / 100.0 : this.amount);
                        targetData.addDP(dpAmount);
                        player.level().playSound(null, target.blockPosition(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    PacketHandler.syncToAllAround(target, targetData);
                }
                break;
            }
            case 4: {
                WorldData worldData;
                Party party;
                float focusAmount = (float)(this.percentage ? playerData.getMaxFocus() * this.amount / 100.0 : this.amount);
                playerData.addFocus(focusAmount);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = WorldData.get(player.getServer())).getPartyFromMember(player.getUUID())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    if (m.getUUID().equals(player.getUUID())) continue;
                    Player target = player.level().getPlayerByUUID(m.getUUID());
                    PlayerData targetData = PlayerData.get(target);
                    if (target.distanceTo((Entity)player) < (float)((Integer)ModConfigs.SERVER.partyRangeLimit.get()).intValue()) {
                        focusAmount = (float)(this.percentage ? targetData.getMaxFocus() * this.amount / 100.0 : this.amount);
                        targetData.addFocus(focusAmount);
                        player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.potion.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    PacketHandler.syncToAllAround(target, targetData);
                }
                break;
            }
        }
        PacketHandler.syncToAllAround(player, playerData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        String sType = Utils.translateToLocal("potion.desc." + this.type.toString().toLowerCase(), new Object[0]);
        String beginning = Utils.translateToLocal("potion.desc.beginning", (int)this.amount, this.percentage ? "%" : "", sType);
        String end = Utils.translateToLocal(this.all ? "potion.desc.toall" : "potion.desc.toone", new Object[0]);
        tooltip.add((Component)Component.translatable((String)(beginning + end)));
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.CONSUMABLE;
    }

    public boolean isGlobal() {
        return this.all;
    }

    public static enum PotionType {
        HP,
        MP,
        HPMP,
        DRIVE,
        FOCUS;

    }
}

