/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.BaseArmorItem;
import online.kingdomkeys.kingdomkeys.menu.PauldronInventory;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KeybladeArmorItem
extends BaseArmorItem {
    public KeybladeArmorItem(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, String textureName) {
        super(materialIn, slot, textureName);
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/models/armor/empty.png");
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onItemDropped(EntityJoinLevelEvent event) {
            ItemStack droppedItem;
            UUID droppedID;
            if (event.getEntity() instanceof ItemEntity && (droppedID = Utils.getArmorID(droppedItem = ((ItemEntity)event.getEntity()).getItem())) != null && droppedItem.getItem() instanceof ArmorItem) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onDeath(LivingDeathEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                for (ItemStack armour : player.getArmorSlots()) {
                    Item item = armour.getItem();
                    if (!(item instanceof ArmorItem)) continue;
                    ArmorItem armorItem = (ArmorItem)item;
                    if (!Utils.hasArmorID(armour)) continue;
                    PauldronInventory pauldronInventory = (PauldronInventory)((Object)PlayerData.get(player).getEquippedKBArmor(0).getCapability(Capabilities.ItemHandler.ITEM));
                    switch (armorItem.getType()) {
                        case HELMET: {
                            pauldronInventory.setStackInSlot(0, armour);
                            break;
                        }
                        case CHESTPLATE: {
                            pauldronInventory.setStackInSlot(1, armour);
                            break;
                        }
                        case LEGGINGS: {
                            pauldronInventory.setStackInSlot(2, armour);
                            break;
                        }
                        case BOOTS: {
                            pauldronInventory.setStackInSlot(3, armour);
                        }
                    }
                    player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                }
            }
        }

        @SubscribeEvent
        public static void onItemToss(ItemTossEvent event) {
            Item item = event.getEntity().getItem().getItem();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                ItemStack droppedItem = event.getEntity().getItem();
                if (Utils.hasArmorID(droppedItem)) {
                    PauldronInventory pauldronInventory = (PauldronInventory)((Object)PlayerData.get(event.getPlayer()).getEquippedKBArmor(0).getCapability(Capabilities.ItemHandler.ITEM));
                    switch (armorItem.getType()) {
                        case HELMET: {
                            pauldronInventory.setStackInSlot(0, droppedItem);
                            break;
                        }
                        case CHESTPLATE: {
                            pauldronInventory.setStackInSlot(1, droppedItem);
                            break;
                        }
                        case LEGGINGS: {
                            pauldronInventory.setStackInSlot(2, droppedItem);
                            break;
                        }
                        case BOOTS: {
                            pauldronInventory.setStackInSlot(3, droppedItem);
                        }
                    }
                    event.getPlayer().level().playSound(null, event.getPlayer().position().x(), event.getPlayer().position().y(), event.getPlayer().position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                }
            }
        }
    }
}

