/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.entity.organization.ArrowgunShotEntity;
import online.kingdomkeys.kingdomkeys.entity.organization.KKThrowableEntity;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.tier.KeybladeItemTier;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSAttackOffhandPacket;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.util.IExtendedReach;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KeybladeItem
extends SwordItem
implements IItemCategory,
IExtendedReach {
    public KeybladeData data;
    private final Item.Properties properties;
    public Recipe recipe;

    public KeybladeItem(Item.Properties properties) {
        super((Tier)new KeybladeItemTier(0.0f), properties.attributes(SwordItem.createAttributes((Tier)new KeybladeItemTier(0.0f), (int)0, (float)-2.4f)).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false)));
        this.properties = properties;
    }

    public int getStrength(int level) {
        return this.data.getStrength(level);
    }

    public int getMagic(int level) {
        return this.data.getMagic(level);
    }

    public int getStrength(ItemStack stack) {
        return this.data.getStrength(this.getKeybladeLevel(stack));
    }

    public int getMagic(ItemStack stack) {
        return this.data.getMagic(this.getKeybladeLevel(stack));
    }

    public String getDesc() {
        return Utils.translateToLocal(this.data.getDescription(), new Object[0]);
    }

    public void setKeybladeData(KeybladeData data) {
        this.data = data;
    }

    public int getKeybladeLevel(ItemStack stack) {
        if (stack.has(ModComponents.KEYBLADE_LEVEL)) {
            return (Integer)stack.get(ModComponents.KEYBLADE_LEVEL);
        }
        return 0;
    }

    public void setKeybladeLevel(ItemStack stack, int level) {
        stack.set(ModComponents.KEYBLADE_LEVEL, (Object)level);
    }

    public int getMaxLevel() {
        return this.data.getMaxLevel();
    }

    public Item.Properties getProperties() {
        return this.properties;
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player && !worldIn.isClientSide && Utils.hasKeybladeID(stack)) {
            PlayerData playerData;
            Player player = (Player)entityIn;
            int slot = itemSlot;
            if (slot == 0 && ItemStack.matches((ItemStack)stack, (ItemStack)player.getOffhandItem())) {
                slot = 40;
            }
            if ((playerData = PlayerData.get(player)) != null) {
                ItemStack mainChain = playerData.getEquippedKeychain(DriveForm.NONE);
                if (playerData.getAlignment() != Utils.OrgMember.NONE) {
                    mainChain = playerData.getEquippedWeapon();
                }
                if (mainChain != null) {
                    ItemStack formChain = null;
                    if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                        formChain = playerData.getEquippedKeychain(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
                    } else if (playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade")) {
                        formChain = playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE);
                    }
                    if (formChain == null) {
                        formChain = ItemStack.EMPTY;
                    }
                    UUID stackID = Utils.getKeybladeID(stack);
                    if (!ItemStack.matches((ItemStack)mainChain, (ItemStack)ItemStack.EMPTY) || !ItemStack.matches((ItemStack)formChain, (ItemStack)ItemStack.EMPTY)) {
                        UUID mainChainID = Utils.getKeybladeID(mainChain);
                        UUID formChainID = Utils.getKeybladeID(formChain);
                        if (mainChainID == null) {
                            mainChainID = new UUID(0L, 0L);
                        }
                        if (formChainID == null) {
                            formChainID = new UUID(0L, 0L);
                        }
                        if (!mainChainID.equals(stackID) && !formChainID.equals(stackID)) {
                            player.getInventory().setItem(slot, ItemStack.EMPTY);
                            player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                        }
                    } else {
                        player.getInventory().setItem(slot, ItemStack.EMPTY);
                        player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    }
                    for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                        UUID id;
                        slot = itemSlot;
                        if (i == 40 && ItemStack.matches((ItemStack)stack, (ItemStack)player.getOffhandItem())) {
                            slot = 40;
                        }
                        if (i == slot || (id = Utils.getKeybladeID(player.getInventory().getItem(i))) == null || !(player.getInventory().getItem(i).getItem() instanceof KeybladeItem) || !id.equals(stackID) || i == player.getInventory().selected) continue;
                        player.getInventory().setItem(i, ItemStack.EMPTY);
                        player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    }
                }
            }
        }
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Level level = player.level();
        PlayerData playerData = PlayerData.get(player);
        if (player.isCrouching() && playerData.isAbilityEquipped("kingdomkeys:ability_strike_raid")) {
            int slot;
            int n = slot = hand == InteractionHand.OFF_HAND ? player.getInventory().getContainerSize() - 1 : player.getInventory().selected;
            if (itemstack != null && !playerData.getRecharge()) {
                int cost = 10;
                cost -= (int)((double)(cost * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_thrift")) * 0.2);
                playerData.remMP(Math.max(1, cost));
                if (!level.isClientSide) {
                    level.playSound(null, player.blockPosition(), (SoundEvent)ModSounds.strike_raid.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    KKThrowableEntity entity = new KKThrowableEntity(level);
                    switch (BuiltInRegistries.ITEM.getKey((Object)itemstack.getItem()).getPath()) {
                        case "retribution": {
                            entity.setRotationPoint(0);
                            break;
                        }
                        default: {
                            entity.setRotationPoint(1);
                        }
                    }
                    entity.setData(DamageCalculation.getKBStrengthDamage(player, itemstack) * 0.7f, player.getUUID(), slot, itemstack);
                    entity.setPos(player.position().x, player.getEyePosition().y, player.position().z);
                    entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 0.0f);
                    level.addFreshEntity((Entity)entity);
                    player.getCooldowns().addCooldown(itemstack.getItem(), 15);
                } else {
                    player.swing(slot == 40 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                }
                return InteractionResultHolder.success((Object)itemstack);
            }
        } else if (!player.getOffhandItem().isEmpty() && player.getOffhandItem().getItem() instanceof KeybladeItem) {
            if (world.isClientSide && !player.getOffhandItem().isEmpty() && player.getOffhandItem().getItem() instanceof KeybladeItem) {
                HitResult rtr;
                Item item = player.getOffhandItem().getItem();
                if (item instanceof IExtendedReach) {
                    IExtendedReach item2 = (IExtendedReach)item;
                    v1 = InputHandler.getMouseOverExtended(item2.getReach());
                } else {
                    v1 = rtr = Minecraft.getInstance().hitResult;
                }
                if (rtr != null) {
                    if (rtr.getType() == HitResult.Type.ENTITY) {
                        EntityHitResult ertr = (EntityHitResult)rtr;
                        if (!ItemStack.matches((ItemStack)player.getItemInHand(InteractionHand.OFF_HAND), (ItemStack)ItemStack.EMPTY) && player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof KeybladeItem && hand == InteractionHand.OFF_HAND) {
                            if (ertr.getEntity() != null) {
                                PacketHandler.sendToServer(new CSAttackOffhandPacket(ertr.getEntity().getId()));
                                return InteractionResultHolder.success((Object)itemstack);
                            }
                            return InteractionResultHolder.fail((Object)itemstack);
                        }
                    } else {
                        player.swing(InteractionHand.OFF_HAND);
                    }
                }
            }
        } else if (playerData.getActiveDriveForm().equals("kingdomkeys:form_wisdom")) {
            player.swing(hand);
            if (!world.isClientSide) {
                ArrowgunShotEntity shot = new ArrowgunShotEntity(player.level(), (LivingEntity)player, DamageCalculation.getMagicDamage(player) * 0.1f);
                shot.setShotType(1);
                shot.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 0.0f);
                world.addFreshEntity((Entity)shot);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.wisdom_shot.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.use(world, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (ModConfigs.keybladeOpenDoors) {
            Level world = context.getLevel();
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            if (world.getBlockState(pos).getBlock() instanceof DoorBlock) {
                SoundEvent sound;
                DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)world.getBlockState(pos).getValue((Property)DoorBlock.HALF);
                if (doubleblockhalf == DoubleBlockHalf.UPPER) {
                    world.setBlockAndUpdate(pos.below(), (BlockState)world.getBlockState(pos.below()).setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf((Boolean)world.getBlockState(pos.below()).getValue((Property)DoorBlock.OPEN) == false)));
                    sound = (Boolean)world.getBlockState(pos.below()).getValue((Property)DoorBlock.OPEN) != false ? SoundEvents.IRON_DOOR_CLOSE : SoundEvents.IRON_DOOR_OPEN;
                } else {
                    world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf((Boolean)world.getBlockState(pos).getValue((Property)DoorBlock.OPEN) == false)));
                    sound = (Boolean)world.getBlockState(pos).getValue((Property)DoorBlock.OPEN) != false ? SoundEvents.IRON_DOOR_CLOSE : SoundEvents.IRON_DOOR_OPEN;
                }
                world.playSound(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (world.getBlockState(pos).getBlock() instanceof TrapDoorBlock) {
                world.setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf((Boolean)world.getBlockState(pos).getValue((Property)TrapDoorBlock.OPEN) == false)));
                SoundEvent sound = (Boolean)world.getBlockState(pos).getValue((Property)TrapDoorBlock.OPEN) != false ? SoundEvents.IRON_DOOR_CLOSE : SoundEvents.IRON_DOOR_OPEN;
                world.playSound(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag flagIn) {
        UUID id;
        if (this.data != null) {
            tooltip = ClientUtils.getTooltip(tooltip, pContext, stack);
            if (this.recipe != null) {
                for (Map.Entry<Item, Integer> mat : this.recipe.getMaterials().entrySet()) {
                    tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.WHITE) + String.valueOf(new ItemStack((ItemLike)mat.getKey()).getHoverName()) + " x" + String.valueOf(mat.getValue()))));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "KEYBLADE DATA MISSING")));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "If you see this then either the keyblade json is missing or failed to load")));
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "It should be located in data/" + key.getNamespace() + "/keyblades/" + key.getPath() + ".json")));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "If the file exists check the syntax, see builtin keyblades for examples")));
        }
        if (flagIn.isAdvanced() && (id = (UUID)stack.get(ModComponents.KEYBLADE_ID)) != null) {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "DEBUG:")));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.WHITE) + id.toString())));
        }
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.TOOL;
    }

    @Override
    public float getReach() {
        return this.data.getReach();
    }

    public boolean isEnchantable(ItemStack pStack) {
        return true;
    }

    @EventBusSubscriber
    public static class KeybladeEvents {
        @SubscribeEvent
        public static void onItemToss(ItemTossEvent event) {
            ItemStack droppedItem = event.getEntity().getItem();
            UUID droppedID = Utils.getKeybladeID(droppedItem);
            if (droppedID != null && droppedItem.getItem() instanceof KeybladeItem) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onItemDropped(EntityJoinLevelEvent event) {
            ItemEntity iEntity;
            ItemStack droppedItem;
            UUID droppedID;
            Entity entity = event.getEntity();
            if (entity instanceof ItemEntity && (droppedID = Utils.getKeybladeID(droppedItem = (iEntity = (ItemEntity)entity).getItem())) != null && droppedItem.getItem() instanceof KeybladeItem) {
                iEntity.level().playSound(null, iEntity.position().x(), iEntity.position().y(), iEntity.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }
}

