/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.tier.KeybladeItemTier;

public class KeychainItem
extends SwordItem
implements IKeychain,
IItemCategory {
    KeybladeItem keyblade;

    public KeychainItem() {
        super((Tier)new KeybladeItemTier(0.0f), new Item.Properties().attributes(SwordItem.createAttributes((Tier)new KeybladeItemTier(0.0f), (int)0, (float)0.0f)).stacksTo(1));
    }

    public void setKeyblade(KeybladeItem kb) {
        this.keyblade = kb;
    }

    public KeybladeItem getKeyblade() {
        return this.keyblade;
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.has(ModComponents.KEYBLADE_ID)) {
            stack.set(ModComponents.KEYBLADE_ID, (Object)UUID.randomUUID());
        }
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        return super.use(world, player, hand);
    }

    public int getKeybladeLevel(ItemStack stack) {
        if (stack.has(ModComponents.KEYBLADE_LEVEL)) {
            return (Integer)stack.get(ModComponents.KEYBLADE_LEVEL);
        }
        return 0;
    }

    public void setKeybladeLevel(ItemStack stack, int level) {
        stack.set(ModComponents.KEYBLADE_LEVEL, (Object)level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.getKeyblade() != null && this.getKeyblade().data != null) {
            tooltip = ClientUtils.getTooltip(tooltip, pContext, stack);
        } else {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "KEYBLADE DATA MISSING")));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "If you see this then either the keyblade json is missing or failed to load")));
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "It should be located in data/" + key.getNamespace() + "/keyblades/YOURKEYBLADEITEMNAMEHERE.json")));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "If the file exists check the syntax, see builtin keyblades for examples")));
        }
        if (flagIn.isAdvanced() && stack.has(ModComponents.KEYBLADE_ID)) {
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "DEBUG:")));
            tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.WHITE) + ((UUID)stack.get(ModComponents.KEYBLADE_ID)).toString())));
        }
    }

    @Override
    public KeybladeItem toSummon() {
        return this.keyblade;
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.TOOL;
    }

    public boolean isEnchantable(ItemStack pStack) {
        return true;
    }
}

