/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagicSpellItem
extends Item
implements IItemCategory {
    String magic;

    public MagicSpellItem(Item.Properties properties, String name) {
        super(properties);
        this.magic = name;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        PlayerData playerData = PlayerData.get(player);
        Magic magicInstance = (Magic)ModMagic.registry.get(ResourceLocation.parse((String)this.magic));
        if (!world.isClientSide) {
            if (playerData != null && playerData.getMagicsMap() != null) {
                if (!playerData.getMagicsMap().containsKey(this.magic)) {
                    playerData.getMagicsMap().put(this.magic, new int[]{0, 0});
                    this.takeItem(player);
                    player.displayClientMessage((Component)Component.translatable((String)"message.unlocked", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(), new Object[0])}), true);
                } else {
                    int actualLevel = playerData.getMagicLevel(ResourceLocation.parse((String)this.magic));
                    if (actualLevel < magicInstance.getMaxLevel()) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.magic_upgrade", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel), new Object[0]), Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel + 1), new Object[0])}), true);
                        playerData.getMagicsMap().put(this.magic, new int[]{actualLevel + 1, 0});
                        this.takeItem(player);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.magic_max_level", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel), new Object[0])}), true);
                    }
                }
                PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            }
        } else if (!playerData.getMagicsMap().containsKey(this.magic) && !ModConfigs.magicDisplayedInCommandMenu.contains(this.magic)) {
            ArrayList<String> list = new ArrayList<String>(ModConfigs.magicDisplayedInCommandMenu);
            list.add(this.magic);
            ModConfigs.setMagicDisplayedInCommandMenu(list);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    private void takeItem(Player player) {
        if (!ItemStack.matches((ItemStack)player.getMainHandItem(), (ItemStack)ItemStack.EMPTY) && player.getMainHandItem().getItem() == this) {
            player.getMainHandItem().shrink(1);
        } else if (!ItemStack.matches((ItemStack)player.getOffhandItem(), (ItemStack)ItemStack.EMPTY) && player.getOffhandItem().getItem() == this) {
            player.getOffhandItem().shrink(1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        Magic magicInstance = (Magic)ModMagic.registry.get(ResourceLocation.parse((String)this.magic));
        if (Minecraft.getInstance().player != null) {
            PlayerData playerData = PlayerData.get((Player)Minecraft.getInstance().player);
            int actualLevel = playerData.getMagicLevel(ResourceLocation.parse((String)this.magic));
            if (!playerData.getMagicsMap().containsKey(this.magic)) {
                --actualLevel;
            }
            if (actualLevel < magicInstance.getMaxLevel()) {
                tooltip.add((Component)Component.translatable((String)"gui.magicspell.unlock", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel + 1), new Object[0])}));
            } else {
                tooltip.add((Component)Component.translatable((String)"gui.magicspell.maxed", (Object[])new Object[]{Utils.translateToLocal(magicInstance.getTranslationKey(actualLevel), new Object[0])}));
            }
        }
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.MISC;
    }
}

