/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ProofOfHeartItem
extends Item {
    public ProofOfHeartItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        PlayerData playerData = PlayerData.get(playerIn);
        if (playerData.getAlignment() != Utils.OrgMember.NONE) {
            if (Utils.isWearingOrgRobes(playerIn)) {
                playerIn.displayClientMessage((Component)Component.translatable((String)"gui.proofofheart.unequip"), true);
            } else {
                if (worldIn.isClientSide && Utils.findSummoned(playerIn.getInventory(), playerData.getEquippedWeapon()) > -1) {
                    PacketHandler.sendToServer(new CSSummonKeyblade(true));
                }
                playerIn.displayClientMessage((Component)Component.translatable((String)"gui.proofofheart.leftorg"), true);
                if (playerIn.getMainHandItem() != null && playerIn.getMainHandItem().getItem() == this) {
                    playerIn.getMainHandItem().shrink(1);
                    playerData.setAlignment(Utils.OrgMember.NONE);
                    return super.use(worldIn, playerIn, handIn);
                }
                if (playerIn.getOffhandItem() != null && playerIn.getOffhandItem().getItem() == this) {
                    playerIn.getOffhandItem().shrink(1);
                    playerData.setAlignment(Utils.OrgMember.NONE);
                    return super.use(worldIn, playerIn, handIn);
                }
            }
        } else {
            playerIn.displayClientMessage((Component)Component.translatable((String)"gui.proofofheart.notinorg"), true);
        }
        return super.use(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"gui.proofofheart.desc"));
        tooltip.add((Component)Component.translatable((String)"gui.proofofheart.desc2"));
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }
}

