/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class RecipeItem
extends Item
implements IItemCategory {
    int tier = 0;

    public RecipeItem(int tier, Item.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !world.isClientSide) {
            ItemStack stack = player.getMainHandItem();
            PlayerData playerData = PlayerData.get(player);
            if (this.tier <= playerData.getSynthLevel()) {
                if (stack.has(ModComponents.RECIPES)) {
                    this.learnRecipes(player, stack);
                } else {
                    List<ResourceLocation> missingKeyblades = this.getMissingRecipes(playerData, "keyblade", this.tier);
                    List<ResourceLocation> missingItems = this.getMissingRecipes(playerData, "item", this.tier);
                    ArrayList<String> types = new ArrayList<String>();
                    types.add("keyblade");
                    types.add("item");
                    if (missingKeyblades.isEmpty()) {
                        types.remove("keyblade");
                    }
                    if (missingItems.isEmpty()) {
                        types.remove("item");
                    }
                    String type = "";
                    if (types.size() > 1) {
                        int num = world.random.nextInt(types.size());
                        type = (String)types.get(num);
                    } else if (types.size() == 1) {
                        type = (String)types.getFirst();
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.recipe.no_more_to_learn"), true);
                        return super.use(world, player, hand);
                    }
                    this.shuffleRecipes(stack, player, type);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.recipe.cant_learn_yet"), true);
            }
        }
        return super.use(world, player, hand);
    }

    private void learnRecipes(Player player, ItemStack stack) {
        List<ResourceLocation> recipes = ((Recipes)stack.getOrDefault(ModComponents.RECIPES, (Object)new Recipes((String)"", new ArrayList<ResourceLocation>()))).recipes;
        PlayerData playerData = PlayerData.get(player);
        if (this.tier > playerData.getSynthLevel()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.recipe.cant_learn_yet"), true);
            return;
        }
        boolean consume = false;
        for (ResourceLocation recipe : recipes) {
            if (!RecipeRegistry.getInstance().containsKey(recipe)) continue;
            ItemStack outputStack = new ItemStack((ItemLike)RecipeRegistry.getInstance().getValue(recipe).getResult());
            if (!RecipeRegistry.getInstance().containsKey(recipe)) {
                String message = "ERROR: Recipe for " + Utils.translateToLocal(recipe.toString(), new Object[0]) + " was not learnt because it is not a valid recipe, Report this to a dev";
                player.sendSystemMessage((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + message)));
                continue;
            }
            if (playerData.hasKnownRecipe(recipe)) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.recipe.already_learnt", (Object[])new Object[]{String.valueOf(ChatFormatting.YELLOW) + Utils.translateToLocal(outputStack.getDescriptionId(), new Object[0])}));
                continue;
            }
            playerData.addKnownRecipe(recipe);
            consume = true;
            player.sendSystemMessage((Component)Component.translatable((String)"message.recipe.learnt", (Object[])new Object[]{String.valueOf(ChatFormatting.GREEN) + Utils.translateToLocal(outputStack.getDescriptionId(), new Object[0])}));
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        }
        if (consume) {
            stack.remove(ModComponents.RECIPES);
            player.getMainHandItem().shrink(1);
        } else {
            this.shuffleRecipes(stack, player, ((Recipes)stack.get(ModComponents.RECIPES)).type);
        }
    }

    public void shuffleRecipes(ItemStack stack, Player player, String type) {
        PlayerData playerData = PlayerData.get(player);
        ArrayList<ResourceLocation> newRecipes = new ArrayList<ResourceLocation>();
        List<ResourceLocation> list = this.getMissingRecipes(playerData, type, this.tier);
        switch (type) {
            case "keyblade": {
                int size = Math.min(list.size(), 3);
                for (int i = 0; i < size; ++i) {
                    int index = Utils.randomWithRange(0, list.size() - 1);
                    newRecipes.add(list.get(index));
                    list.remove(index);
                }
                break;
            }
            case "item": {
                if (list.isEmpty()) break;
                newRecipes.add(list.get(Utils.randomWithRange(0, list.size() - 1)));
            }
        }
        stack.set(ModComponents.RECIPES, (Object)new Recipes(type, newRecipes));
        if (!newRecipes.isEmpty()) {
            this.learnRecipes(player, stack);
        }
    }

    private List<ResourceLocation> getMissingRecipes(PlayerData playerData, String type, int tier) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Recipe r : RecipeRegistry.getInstance().getValues()) {
            if (playerData.hasKnownRecipe(r.getRegistryName()) || !r.getType().equals(type)) continue;
            if (tier == 0) {
                list.add(r.getRegistryName());
                continue;
            }
            if (r.getTier() != tier) continue;
            list.add(r.getRegistryName());
        }
        return list;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.has(ModComponents.RECIPES)) {
            List<ResourceLocation> recipes = ((Recipes)stack.get(ModComponents.RECIPES)).recipes;
            recipes.forEach(recipeRL -> {
                Recipe recipe;
                if (RecipeRegistry.getInstance().containsKey((ResourceLocation)recipeRL) && (recipe = RecipeRegistry.getInstance().getValue((ResourceLocation)recipeRL)) != null) {
                    String name;
                    if (recipe.getType().equals("keyblade")) {
                        KeychainItem item = (KeychainItem)recipe.getResult();
                        name = new ItemStack((ItemLike)item.keyblade).getDescriptionId();
                    } else {
                        name = new ItemStack((ItemLike)recipe.getResult()).getDescriptionId();
                    }
                    tooltip.add((Component)Component.translatable((String)Utils.translateToLocal(name, new Object[0])));
                }
            });
        }
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.MISC;
    }

    public record Recipes(String type, List<ResourceLocation> recipes) {
        public static final Codec<Recipes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(Recipes::type), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("recipes").forGetter(Recipes::recipes)).apply((Applicative)instance, Recipes::new));
        public static final StreamCodec<FriendlyByteBuf, Recipes> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Recipes::type, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ResourceLocation.STREAM_CODEC), Recipes::recipes, Recipes::new);
    }
}

