/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

public class StatUpgradeItem
extends Item
implements IItemCategory {
    String boost;

    public StatUpgradeItem(Item.Properties properties, String name) {
        super(properties);
        this.boost = name;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        PlayerData playerData;
        if (!world.isClientSide && (playerData = PlayerData.get(player)) != null) {
            this.takeItem(player);
            switch (this.boost) {
                case "powerboost": {
                    playerData.getStrengthStat().addModifier("boost", 1.0, true, false);
                    player.displayClientMessage((Component)Component.translatable((String)"gui.statboost.increased", (Object[])new Object[]{Component.translatable((String)"gui.menu.status.strength"), playerData.getStrength(true)}), true);
                    break;
                }
                case "magicboost": {
                    playerData.getMagicStat().addModifier("boost", 1.0, true, false);
                    player.displayClientMessage((Component)Component.translatable((String)"gui.statboost.increased", (Object[])new Object[]{Component.translatable((String)"gui.menu.status.magic"), playerData.getMagic(true)}), true);
                    break;
                }
                case "defenseboost": {
                    playerData.getDefenseStat().addModifier("boost", 1.0, true, false);
                    player.displayClientMessage((Component)Component.translatable((String)"gui.statboost.increased", (Object[])new Object[]{Component.translatable((String)"gui.menu.status.defense"), playerData.getDefense(true)}), true);
                    break;
                }
                case "apboost": {
                    playerData.getMaxAPStat().addModifier("boost", 1.0, true, false);
                    player.displayClientMessage((Component)Component.translatable((String)"gui.statboost.increased", (Object[])new Object[]{Component.translatable((String)"gui.menu.status.ap"), playerData.getMaxAP(true)}), true);
                }
            }
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    private void takeItem(Player player) {
        if (!ItemStack.matches((ItemStack)player.getMainHandItem(), (ItemStack)ItemStack.EMPTY) && player.getMainHandItem().getItem() == this) {
            player.getMainHandItem().shrink(1);
        } else if (!ItemStack.matches((ItemStack)player.getOffhandItem(), (ItemStack)ItemStack.EMPTY) && player.getOffhandItem().getItem() == this) {
            player.getOffhandItem().shrink(1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (Minecraft.getInstance().player != null) {
            switch (this.boost) {
                case "powerboost": {
                    tooltip.add((Component)Component.translatable((String)"gui.statboost.tooltip", (Object[])new Object[]{Component.translatable((String)"gui.menu.status.strength")}));
                    break;
                }
                case "magicboost": {
                    tooltip.add((Component)Component.translatable((String)"gui.statboost.tooltip", (Object[])new Object[]{Component.translatable((String)"gui.menu.status.magic")}));
                    break;
                }
                case "defenseboost": {
                    tooltip.add((Component)Component.translatable((String)"gui.statboost.tooltip", (Object[])new Object[]{Component.translatable((String)"gui.menu.status.defense")}));
                    break;
                }
                case "apboost": {
                    tooltip.add((Component)Component.translatable((String)"gui.statboost.tooltip", (Object[])new Object[]{Component.translatable((String)"gui.menu.status.ap")}));
                }
            }
        }
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.BUILDING;
    }
}

