/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.joml.Vector3f;

public class WayfinderItem
extends Item {
    Player owner;

    public WayfinderItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (!stack.has(ModComponents.WAYFINDER_OWNER)) {
                this.setID(stack, player);
            }
            if (!worldIn.isClientSide) {
                PlayerData playerData;
                if (this.owner == null) {
                    this.owner = this.getOwner((ServerLevel)player.level(), stack);
                }
                if (this.owner != null && (playerData = PlayerData.get(this.owner)) != null && playerData.getNotifColor() != this.getColor(stack)) {
                    stack.set(ModComponents.WAYFINDER_COLOR, (Object)playerData.getNotifColor());
                }
            }
            super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide) {
            ServerLevel serverLevel = (ServerLevel)world;
            ItemStack stack = player.getItemInHand(hand);
            WayfinderOwner ownerdata = (WayfinderOwner)stack.get(ModComponents.WAYFINDER_OWNER);
            this.owner = this.getOwner(serverLevel, stack);
            if (this.owner == null) {
                player.displayClientMessage((Component)Component.translatable((String)"message.wayfinder.player_not_found", (Object[])new Object[]{ownerdata.name}), true);
                return super.use(world, player, hand);
            }
            Party p = WorldData.get(world.getServer()).getPartyFromMember(player.getUUID());
            if (this.owner == player) {
                player.displayClientMessage((Component)Component.translatable((String)"message.wayfinder.your_wayfinder").append(" ").append((Boolean)ModConfigs.SERVER.wayfinderParty.get() != false ? Component.translatable((String)"message.wayfinder.in_your_party").getString() : ""), true);
                return super.use(world, player, hand);
            }
            if (((Boolean)ModConfigs.SERVER.wayfinderParty.get()).booleanValue()) {
                if (p == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.wayfinder.not_in_party"), true);
                    return super.use(world, player, hand);
                }
                if (!Utils.isEntityInParty(p, (Entity)player)) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.wayfinder.player_not_in_party", (Object[])new Object[]{ownerdata.name}), true);
                    return super.use(world, player, hand);
                }
            }
            this.teleport(player, (Entity)this.owner, this.getColor(player.getItemInHand(hand)));
        }
        return super.use(world, player, hand);
    }

    public void teleport(Player player, Entity owner, int color) {
        if (player.level().dimension() != owner.level().dimension()) {
            ServerLevel destiinationWorld = owner.getServer().getLevel(owner.level().dimension());
            player.changeDimension(new DimensionTransition(destiinationWorld, new Vec3(owner.getX(), owner.getY(), owner.getZ()), Vec3.ZERO, player.getYRot(), player.getXRot(), entity -> {}));
        }
        player.teleportTo(owner.getX(), owner.getY(), owner.getZ());
        player.setDeltaMovement(0.0, 0.0, 0.0);
        player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.unsummon_armor.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        ((ServerLevel)player.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 6.0f), player.getX(), player.getY() + 1.5, player.getZ(), 150, 0.0, 0.0, 0.0, 0.2);
        ((ServerLevel)player.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 6.0f), player.getX(), player.getY() + 1.0, player.getZ(), 150, 0.0, 0.0, 0.0, 0.2);
        ((ServerLevel)player.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 6.0f), player.getX(), player.getY() + 0.5, player.getZ(), 150, 0.0, 0.0, 0.0, 0.2);
        ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.FIREWORK, player.getX(), player.getY() + 1.0, player.getZ(), 300, 0.0, 0.0, 0.0, 0.2);
        player.getCooldowns().addCooldown((Item)this, 6000);
    }

    public void setID(ItemStack stack, Player player) {
        stack.set(ModComponents.WAYFINDER_OWNER, (Object)new WayfinderOwner(player.getUUID(), player.getDisplayName().getString()));
        PlayerData playerData = PlayerData.get(player);
        stack.set(ModComponents.WAYFINDER_COLOR, (Object)playerData.getNotifColor());
    }

    public Player getOwner(ServerLevel level, ItemStack stack) {
        if (!stack.has(ModComponents.WAYFINDER_OWNER)) {
            return null;
        }
        UUID playerUUID = ((WayfinderOwner)stack.get(ModComponents.WAYFINDER_OWNER)).uuid;
        for (Player p : Utils.getAllPlayers(level.getServer())) {
            if (!p.getUUID().equals(playerUUID)) continue;
            return p;
        }
        return null;
    }

    public int getColor(ItemStack stack) {
        if (!stack.has(ModComponents.WAYFINDER_COLOR)) {
            return Color.WHITE.getRGB();
        }
        return (Integer)stack.get(ModComponents.WAYFINDER_COLOR);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.has(ModComponents.WAYFINDER_OWNER)) {
            tooltip.add((Component)Component.translatable((String)"message.wayfinder.owner", (Object[])new Object[]{((WayfinderOwner)stack.get(ModComponents.WAYFINDER_OWNER)).name}));
            if (Minecraft.getInstance().player.getCooldowns().isOnCooldown((Item)this)) {
                tooltip.add((Component)Component.translatable((String)"message.wayfinder.cooldown", (Object[])new Object[]{(int)(Minecraft.getInstance().player.getCooldowns().getCooldownPercent((Item)this, 0.0f) * 100.0f)}));
            }
        }
    }

    public boolean isEnchantable(ItemStack pStack) {
        return false;
    }

    public record WayfinderOwner(UUID uuid, String name) {
        public static final Codec<WayfinderOwner> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(WayfinderOwner::uuid), (App)Codec.STRING.fieldOf("name").forGetter(WayfinderOwner::name)).apply((Applicative)instance, WayfinderOwner::new));
        public static final StreamCodec<FriendlyByteBuf, WayfinderOwner> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, WayfinderOwner::uuid, (StreamCodec)ByteBufCodecs.STRING_UTF8, WayfinderOwner::name, WayfinderOwner::new);
    }
}

