/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item.card;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;

public class MapCardItem
extends Item {
    private final Supplier<RoomType> type;

    public MapCardItem(Supplier<RoomType> type) {
        super(new Item.Properties().fireResistant());
        this.type = type;
    }

    public RoomType getRoomType() {
        return this.type.get();
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pStack.has(ModComponents.CARD_VALUE)) {
            this.generateValue(pStack);
        } else {
            pStack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.mapcard.prefix", (Object[])new Object[]{this.getCardValue(pStack), Component.translatable((String)("item." + BuiltInRegistries.ITEM.getKey((Object)this).getNamespace() + "." + BuiltInRegistries.ITEM.getKey((Object)this).getPath()))}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false))));
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    private void generateValue(ItemStack stack) {
        stack.set(ModComponents.CARD_VALUE, (Object)Utils.randomWithRange(0, 9));
    }

    public int getCardValue(ItemStack stack) {
        if (stack.has(ModComponents.CARD_VALUE)) {
            return (Integer)stack.get(ModComponents.CARD_VALUE);
        }
        return -1;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext tooltipContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (this.type != null) {
            RoomType inst = this.type.get();
            pTooltipComponents.add((Component)Component.translatable((String)("Size: " + inst.getSize().ordinal())));
            pTooltipComponents.add((Component)Component.translatable((String)("Enemies: " + inst.getEnemies().ordinal())));
        }
        super.appendHoverText(pStack, tooltipContext, pTooltipComponents, pIsAdvanced);
    }
}

