/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item.organization;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.organization.ArrowgunShotEntity;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrgSwordItem;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ArrowgunItem
extends OrgSwordItem
implements IOrgWeapon {
    int ammo = 10;
    int reload = 30;
    int tempAmmo;

    @Override
    public Utils.OrgMember getMember() {
        return Utils.OrgMember.XIGBAR;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            if (player.getItemInHand(hand).has(ModComponents.ARROWGUN_AMMO) && (Integer)player.getItemInHand(hand).get(ModComponents.ARROWGUN_AMMO) > 0) {
                world.playSound(player, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.sharpshooterbullet.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                ArrowgunShotEntity bullet = new ArrowgunShotEntity(world, (LivingEntity)player, DamageCalculation.getOrgStrengthDamage(player, player.getMainHandItem()) / 3.0f);
                bullet.setPos(bullet.getX(), bullet.getY(), bullet.getZ());
                bullet.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 0.0f);
                world.addFreshEntity((Entity)bullet);
                this.tempAmmo = (Integer)player.getItemInHand(hand).get(ModComponents.ARROWGUN_AMMO) - 1;
                player.getItemInHand(hand).set(ModComponents.ARROWGUN_AMMO, (Object)this.tempAmmo);
                if (this.tempAmmo == 0) {
                    player.getItemInHand(hand).set(ModComponents.ARROWGUN_AMMO, (Object)this.getMaxAmmo(player));
                    player.getCooldowns().addCooldown((Item)this, this.reload);
                    world.playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.arrowgunReload.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        } else {
            Integer ammo = (Integer)player.getItemInHand(hand).get(ModComponents.ARROWGUN_AMMO);
            if (ammo != null && ammo > 0) {
                world.playSound(player, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.arrowgunReload.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.getCooldowns().addCooldown((Item)this, this.reload / ammo);
                player.getItemInHand(hand).set(ModComponents.ARROWGUN_AMMO, (Object)this.getMaxAmmo(player));
                player.swing(InteractionHand.MAIN_HAND);
            }
            return super.use(world, player, hand);
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    private int getMaxAmmo(Player player) {
        PlayerData playerData = PlayerData.get(player);
        if (playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade")) {
            return this.ammo * 2;
        }
        return this.ammo;
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.isClientSide && !itemStack.has(ModComponents.ARROWGUN_AMMO)) {
                itemStack.set(ModComponents.ARROWGUN_AMMO, (Object)this.getMaxAmmo(player));
            }
        }
    }
}

