/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item.organization;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrgSwordItem;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class AxeSwordItem
extends OrgSwordItem
implements IOrgWeapon {
    @Override
    public Utils.OrgMember getMember() {
        return Utils.OrgMember.LEXAEUS;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        PlayerData playerData = PlayerData.get(player);
        float dmg = (float)playerData.getStrengthStat().get();
        if (!player.isShiftKeyDown()) {
            if (player.onGround()) {
                player.setDeltaMovement(player.getDeltaMovement().add(0.0, 0.8, 0.0));
                world.addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0);
                if (!player.isDescending()) {
                    world.addParticle((ParticleOptions)ParticleTypes.CLOUD, player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0);
                }
                player.getCooldowns().addCooldown((Item)this, 5);
            }
            if (!player.onGround()) {
                List<LivingEntity> targetList = Utils.getLivingEntitiesInRadiusExcludingParty(player, (Entity)player, 3.0f, 3.0f, 3.0f);
                for (LivingEntity e : targetList) {
                    System.out.println("Falling Strike: " + (dmg *= player.fallDistance + 2.0f));
                    e.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.DARKNESS, (Entity)e, (Entity)player), dmg);
                    world.explode((Entity)player, player.getX(), player.getY(), player.getZ(), 3.0f, false, Level.ExplosionInteraction.NONE);
                    player.swing(hand);
                    player.getCooldowns().addCooldown((Item)this, 20);
                }
            }
        }
        return super.use(world, player, hand);
    }
}

