/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item.organization;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.entity.organization.LanceEntity;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrgSwordItem;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class LanceItem
extends OrgSwordItem
implements IOrgWeapon {
    @Override
    public Utils.OrgMember getMember() {
        return Utils.OrgMember.XALDIN;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        int slot;
        ItemStack stack = player.getItemInHand(hand);
        Level level = player.level();
        int n = slot = hand == InteractionHand.OFF_HAND ? player.getInventory().getContainerSize() - 1 : player.getInventory().selected;
        if (!level.isClientSide && stack != null) {
            player.getCooldowns().addCooldown((Item)this, 10);
            LanceEntity entity = new LanceEntity(level);
            switch (BuiltInRegistries.ITEM.getKey((Object)this).getPath()) {
                case "lindworm": {
                    entity.setRotationPoint(0);
                    break;
                }
                default: {
                    entity.setRotationPoint(2);
                }
            }
            entity.setData(DamageCalculation.getOrgStrengthDamage(player, stack), player.getUUID(), slot, stack);
            entity.setPos(player.position().x, player.getEyePosition().y, player.position().z);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 0.0f);
            level.addFreshEntity((Entity)entity);
            return super.use(world, player, hand);
        }
        if (level.isClientSide()) {
            player.swing(slot == 40 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        }
        return InteractionResultHolder.consume((Object)stack);
    }
}

