/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item.organization;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.organization.KKThrowableEntity;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrgSwordItem;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ScytheItem
extends OrgSwordItem
implements IOrgWeapon {
    @Override
    public Utils.OrgMember getMember() {
        return Utils.OrgMember.MARLUXIA;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Level level = player.level();
        int slot = hand == InteractionHand.OFF_HAND ? player.getInventory().getContainerSize() - 1 : player.getInventory().selected;
        PlayerData playerData = PlayerData.get(player);
        if (stack != null && !playerData.getRecharge() && playerData.isAbilityEquipped("kingdomkeys:ability_strike_raid")) {
            int cost = 10;
            cost = (int)((double)cost - (double)(cost * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_thrift")) * 0.2);
            playerData.remMP(Math.max(1, cost));
            player.swing(hand);
            if (!level.isClientSide) {
                player.setItemInHand(hand, ItemStack.EMPTY);
                KKThrowableEntity entity = new KKThrowableEntity(level);
                switch (BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath()) {
                    case "graceful_dahlia": 
                    case "proud_amaryllis": 
                    case "mad_safflower": 
                    case "tragic_allium": 
                    case "mournful_cineria": 
                    case "pseudo_silene": 
                    case "faithless_digitalis": 
                    case "grim_muscari": 
                    case "docile_vallota": 
                    case "parting_ipheion": 
                    case "gallant_achillea": 
                    case "noble_peony": 
                    case "fearsome_anise": 
                    case "vindictive_thistle": 
                    case "fair_helianthus": 
                    case "stirring_ladle": 
                    case "dainty_bellflowers": {
                        entity.setRotationPoint(1);
                        break;
                    }
                    default: {
                        entity.setRotationPoint(0);
                    }
                }
                entity.setData(DamageCalculation.getOrgStrengthDamage(player, stack), player.getUUID(), slot, stack);
                entity.setPos(player.position().x, player.getEyePosition().y, player.position().z);
                entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 0.0f);
                level.addFreshEntity((Entity)entity);
                return super.use(world, player, hand);
            }
        }
        return InteractionResultHolder.consume((Object)stack);
    }
}

